/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class DeflatingStreamSinkConduit
implements StreamSinkConduit {
    private final Deflater deflater = new Deflater(8, true);
    private final ConduitFactory<StreamSinkConduit> conduitFactory;
    private final HttpServerExchange exchange;
    private StreamSinkConduit next;
    private WriteReadyHandler writeReadyHandler;
    private final Pooled<ByteBuffer> currentBuffer;
    private ByteBuffer additionalBuffer;
    private int state = 0;
    private static final int SHUTDOWN = 1;
    private static final int next_SHUTDOWN = 2;
    private static final int FLUSHING_BUFFER = 4;
    private static final int WRITES_RESUMED = 8;
    private static final int CLOSED = 16;

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange) {
        this.currentBuffer = exchange.getConnection().getBufferPool().allocate();
        this.exchange = exchange;
        this.conduitFactory = conduitFactory;
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)17, (int)this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0;
        }
        if (src.remaining() == 0) {
            return 0;
        }
        byte[] data = new byte[src.remaining()];
        src.get(data);
        this.deflater.setInput(data);
        this.deflateData();
        return data.length;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet((int)17, (int)this.state)) {
            throw new ClosedChannelException();
        }
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            int ret = this.write(srcs[i]);
            total += ret;
            if (ret != 0) continue;
            return total;
        }
        return total;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)17, (int)this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)17, (int)this.state)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public XnioWorker getWorker() {
        return this.exchange.getConnection().getWorker();
    }

    public void suspendWrites() {
        if (this.next == null) {
            this.state &= 0xFFFFFFF7;
        } else {
            this.next.suspendWrites();
        }
    }

    public boolean isWriteResumed() {
        if (this.next == null) {
            return Bits.anyAreSet((int)8, (int)this.state);
        }
        return this.next.isWriteResumed();
    }

    public void wakeupWrites() {
        if (this.next == null) {
            this.resumeWrites();
        } else {
            this.next.wakeupWrites();
        }
    }

    public void resumeWrites() {
        if (this.next == null) {
            this.state |= 8;
            this.queueWriteListener();
        } else {
            this.next.resumeWrites();
        }
    }

    private void queueWriteListener() {
        this.exchange.getConnection().getIoThread().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DeflatingStreamSinkConduit.this.writeReadyHandler != null) {
                    try {
                        DeflatingStreamSinkConduit.this.writeReadyHandler.writeReady();
                    }
                    finally {
                        if (DeflatingStreamSinkConduit.this.next == null && DeflatingStreamSinkConduit.this.isWriteResumed()) {
                            DeflatingStreamSinkConduit.this.queueWriteListener();
                        }
                    }
                }
            }
        });
    }

    public void terminateWrites() throws IOException {
        this.deflater.finish();
        this.state |= 1;
    }

    public boolean isWriteShutdown() {
        return Bits.anyAreSet((int)this.state, (int)1);
    }

    public void awaitWritable() throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable(time, timeUnit);
    }

    public XnioIoThread getWriteThread() {
        return this.exchange.getConnection().getIoThread();
    }

    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        boolean nextCreated = false;
        try {
            if (Bits.anyAreSet((int)1, (int)this.state)) {
                if (Bits.anyAreSet((int)2, (int)this.state)) {
                    boolean bl = this.next.flush();
                    return bl;
                }
                if (!this.performFlushIfRequired()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.deflater.finished()) {
                    this.deflateData();
                    if (!this.deflater.finished()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (!Bits.anyAreSet((int)4, (int)this.state)) {
                    ((ByteBuffer)this.currentBuffer.getResource()).flip();
                    this.state |= 4;
                    if (this.next == null) {
                        nextCreated = true;
                        this.createnext();
                    }
                }
                if (this.performFlushIfRequired()) {
                    this.state |= 2;
                    this.currentBuffer.free();
                    this.next.terminateWrites();
                    boolean bl = this.next.flush();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.performFlushIfRequired();
            return bl;
        }
        finally {
            if (nextCreated && Bits.anyAreSet((int)8, (int)this.state) && !Bits.anyAreSet((int)2, (int)this.state)) {
                this.next.resumeWrites();
            }
        }
    }

    private boolean performFlushIfRequired() throws IOException {
        if (Bits.anyAreSet((int)4, (int)this.state)) {
            ByteBuffer[] bufs = new ByteBuffer[this.additionalBuffer == null ? 1 : 2];
            long totalLength = 0L;
            bufs[0] = (ByteBuffer)this.currentBuffer.getResource();
            totalLength += (long)bufs[0].remaining();
            if (this.additionalBuffer != null) {
                bufs[1] = this.additionalBuffer;
                totalLength += (long)bufs[1].remaining();
            }
            if (totalLength > 0L) {
                long total = 0L;
                long res = 0L;
                do {
                    res = this.next.write(bufs, 0, bufs.length);
                    total += res;
                    if (res != 0L) continue;
                    return false;
                } while (total < totalLength);
            }
            this.additionalBuffer = null;
            ((ByteBuffer)this.currentBuffer.getResource()).clear();
            this.state &= 0xFFFFFFFB;
        }
        return true;
    }

    private void createnext() {
        if (this.deflater.finished()) {
            int remaining = ((ByteBuffer)this.currentBuffer.getResource()).remaining();
            if (this.additionalBuffer != null) {
                remaining += this.additionalBuffer.remaining();
            }
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(remaining));
        } else {
            this.exchange.getResponseHeaders().remove(Headers.CONTENT_LENGTH);
        }
        this.next = this.conduitFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deflateData() throws IOException {
        boolean nextCreated = false;
        try {
            Pooled<ByteBuffer> pooled = this.currentBuffer;
            ByteBuffer outputBuffer = (ByteBuffer)pooled.getResource();
            boolean shutdown = Bits.anyAreSet((int)1, (int)this.state);
            byte[] buffer = new byte[1024];
            while (!this.deflater.needsInput() || shutdown && !this.deflater.finished()) {
                int count = this.deflater.deflate(buffer);
                if (count == 0) continue;
                int remaining = outputBuffer.remaining();
                if (remaining > count) {
                    outputBuffer.put(buffer, 0, count);
                    continue;
                }
                if (remaining == count) {
                    outputBuffer.put(buffer, 0, count);
                } else {
                    outputBuffer.put(buffer, 0, remaining);
                    this.additionalBuffer = ByteBuffer.wrap(buffer, remaining, count - remaining);
                }
                outputBuffer.flip();
                this.state |= 4;
                if (this.next == null) {
                    nextCreated = true;
                    this.createnext();
                }
                if (this.performFlushIfRequired()) continue;
                return;
            }
        }
        finally {
            if (nextCreated && Bits.anyAreSet((int)8, (int)this.state)) {
                this.next.resumeWrites();
            }
        }
    }

    public void truncateWrites() throws IOException {
        if (!Bits.anyAreSet((int)2, (int)this.state)) {
            this.currentBuffer.free();
        }
        this.state |= 0x10;
        this.next.truncateWrites();
    }
}

