/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import io.undertow.server.handlers.cache.ResponseCachingStreamSinkConduit;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ConduitFactory;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import org.xnio.conduits.StreamSinkConduit;

public class CachedResource
implements Resource {
    private final String cacheKey;
    private final CachingResourceManager cachingResourceManager;
    private final Resource underlyingResource;
    private final String path;
    private final Long contentLength;
    private final boolean directory;
    private final Date lastModifiedDate;
    private final String lastModifiedDateString;
    private final ETag eTag;
    private final String name;

    public CachedResource(CachingResourceManager cachingResourceManager, Resource underlyingResource, String path) {
        this.cachingResourceManager = cachingResourceManager;
        this.underlyingResource = underlyingResource;
        this.contentLength = underlyingResource.getContentLength();
        this.directory = underlyingResource.isDirectory();
        this.lastModifiedDate = underlyingResource.getLastModified();
        this.lastModifiedDateString = this.lastModifiedDate != null ? DateUtils.toDateString(this.lastModifiedDate) : null;
        this.eTag = underlyingResource.getETag();
        this.name = underlyingResource.getName();
        this.path = this.directory && !path.endsWith("/") ? path + "/" : path;
        this.cacheKey = underlyingResource.getCacheKey();
    }

    @Override
    public Date getLastModified() {
        return this.lastModifiedDate;
    }

    @Override
    public String getLastModifiedString() {
        return this.lastModifiedDateString;
    }

    @Override
    public ETag getETag() {
        return this.eTag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public List<Resource> list() {
        return this.underlyingResource.list();
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        return this.underlyingResource.getContentType(mimeMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(HttpServerExchange exchange) {
        ByteBuffer[] buffers;
        final Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            this.underlyingResource.serve(exchange);
            return;
        }
        final DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            this.underlyingResource.serve(exchange);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        if (existing == null || !existing.enabled() || !existing.reference()) {
            exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

                @Override
                public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                    DirectBufferCache.CacheEntry entry = dataCache.add(CachedResource.this.cacheKey, length.intValue());
                    if (entry == null || entry.buffers().length == 0 || !entry.claimEnable()) {
                        return factory.create();
                    }
                    if (!entry.reference()) {
                        entry.disable();
                        return factory.create();
                    }
                    return new ResponseCachingStreamSinkConduit(factory.create(), entry, length);
                }
            });
            this.underlyingResource.serve(exchange);
            return;
        }
        boolean ok = false;
        try {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
            buffers = new ByteBuffer[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = pooled[i].getResource().duplicate();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                existing.dereference();
            }
        }
        exchange.getResponseSender().send(buffers, (IoCallback)new DereferenceCallback(existing));
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        for (String p : possible) {
            try {
                Resource res = this.cachingResourceManager.getResource(this.path + p);
                if (res == null) continue;
                return res;
            }
            catch (IOException e) {
                UndertowLogger.ROOT_LOGGER.debugf(e, "Exception getting resource %s", this.path + p);
            }
        }
        return null;
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Path getFile() {
        return this.underlyingResource.getFile();
    }

    @Override
    public URL getUrl() {
        return this.underlyingResource.getUrl();
    }

    private static class DereferenceCallback
    implements IoCallback {
        private final DirectBufferCache.CacheEntry cache;

        public DereferenceCallback(DirectBufferCache.CacheEntry cache) {
            this.cache = cache;
        }

        @Override
        public void onComplete(HttpServerExchange exchange, Sender sender) {
            this.cache.dereference();
        }

        @Override
        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
            this.cache.dereference();
        }
    }
}

