/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpClientRequest;
import io.undertow.client.PendingHttpRequest;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.xnio.channels.StreamSourceChannel;

public final class HttpClientResponse
extends AbstractAttachable {
    private final HttpClientRequest request;
    private final String reason;
    private final int responseCode;
    private final HeaderMap headers;
    private final long contentLength;
    private final HttpString protocol;
    private final StreamSourceChannel sourceChannel;

    protected HttpClientResponse(PendingHttpRequest responseBuilder, HttpClientRequest request, long contentLength, StreamSourceChannel sourceChannel) {
        this.request = request;
        this.protocol = responseBuilder.getProtocol();
        this.reason = responseBuilder.getReasonPhrase();
        this.responseCode = responseBuilder.getStatusCode();
        this.headers = responseBuilder.getResponseHeaders();
        this.contentLength = contentLength;
        this.sourceChannel = sourceChannel;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public HeaderMap getResponseHeaders() {
        return this.headers;
    }

    public StreamSourceChannel readReplyBody() throws IOException {
        return this.sourceChannel;
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public HttpClientRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return "HttpClientResponse{" + this.protocol + " " + this.responseCode + " " + this.reason + ", headers=" + this.headers + '}';
    }
}

