/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;
import org.xnio.channels.StreamSinkChannel;

abstract class AbstractSender {
    protected final WebSocketChannelSession session;

    AbstractSender(WebSocketChannelSession session) {
        this.session = session;
    }

    protected StreamSinkChannel createSink(long payloadSize) throws IOException {
        WebSocketFrameType type;
        if (this.session.closeFrameSent) {
            WebSocketMessages.MESSAGES.closeFrameSentBefore();
        }
        if ((type = this.type()) == WebSocketFrameType.CLOSE) {
            this.session.closeFrameSent = true;
        }
        return this.session.getChannel().send(type, payloadSize);
    }

    protected final void checkBlockingAllowed() {
        if (this.session.executeInIoThread) {
            WebSocketMessages.MESSAGES.blockingOperationInIoThread();
        }
    }

    protected abstract WebSocketFrameType type();
}

