/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.accesslog.CombinedTokenFactory;
import io.undertow.server.handlers.accesslog.ConstantAccessLogToken;
import io.undertow.server.handlers.accesslog.TokenHandler;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.net.InetSocketAddress;
import java.util.Date;

public class DefaultAccessLogTokens
implements TokenHandler.Factory {
    public static final String REMOTE_IP = "%a";
    public static final String LOCAL_IP = "%A";
    public static final String BYTES_SENT_DASH = "%b";
    public static final String BYTES_SENT = "%B";
    public static final String REMOTE_HOST_NAME = "%h";
    public static final String REQUEST_PROTOCOL = "%H";
    public static final String IDENT_USERNAME = "%l";
    public static final String METHOD = "%m";
    public static final String LOCAL_PORT = "%p";
    public static final String QUERY_STRING = "%q";
    public static final String REQUEST_LINE = "%r";
    public static final String STATUS_CODE = "%s";
    public static final String DATE_TIME = "%t";
    public static final String REMOTE_USER = "%u";
    public static final String REQUESTED_URL = "%U";
    public static final String LOCAL_SERVER_NAME = "%v";
    public static final String TIME_TO_PROCESS_MILLIS = "%D";
    public static final String TIME_TO_PROCESS_SECONDS = "%T";
    public static final String THREAD_NAME = "%I";
    public static final String COMMON = "common";
    public static final String COMBINED = "combined";
    public static final DefaultAccessLogTokens INSTANCE = new DefaultAccessLogTokens();
    private static final CombinedTokenFactory FACTORY = new CombinedTokenFactory(DefaultAccessLogTokens.remoteIp(), DefaultAccessLogTokens.localIp(), DefaultAccessLogTokens.requestProtocol(), DefaultAccessLogTokens.identUsername(), DefaultAccessLogTokens.requestMethod(), DefaultAccessLogTokens.localPort(), DefaultAccessLogTokens.queryString(), DefaultAccessLogTokens.requestLine(), DefaultAccessLogTokens.statusCode(), DefaultAccessLogTokens.dateTime(), DefaultAccessLogTokens.remoteUser(), DefaultAccessLogTokens.requestedUrl(), DefaultAccessLogTokens.threadName(), DefaultAccessLogTokens.localServerName(), DefaultAccessLogTokens.incomingHeaders(), DefaultAccessLogTokens.outgoingHeaders(), DefaultAccessLogTokens.cookies());

    @Override
    public TokenHandler create(String token) {
        return FACTORY.create(token);
    }

    public static final TokenHandler.Factory remoteIp() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.REMOTE_IP) || token.equals(DefaultAccessLogTokens.REMOTE_HOST_NAME)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            InetSocketAddress peerAddress = (InetSocketAddress)exchange.getConnection().getPeerAddress();
                            return peerAddress.getAddress().getHostAddress();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory localIp() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.LOCAL_IP)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            InetSocketAddress localAddress = (InetSocketAddress)exchange.getConnection().getLocalAddress();
                            return localAddress.getAddress().getHostAddress();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory localPort() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.LOCAL_PORT)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            InetSocketAddress localAddress = (InetSocketAddress)exchange.getConnection().getLocalAddress();
                            return Integer.toString(localAddress.getPort());
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory requestProtocol() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.REQUEST_PROTOCOL)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getProtocol().toString();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory identUsername() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.IDENT_USERNAME)) {
                    return new ConstantAccessLogToken("-");
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory requestMethod() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.METHOD)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getRequestMethod().toString();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory queryString() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.QUERY_STRING)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getQueryString();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory requestLine() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.REQUEST_LINE)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getRequestMethod().toString() + ' ' + exchange.getRequestURI() + ' ' + exchange.getProtocol().toString();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory statusCode() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.STATUS_CODE)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return Integer.toString(exchange.getResponseCode());
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory dateTime() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.DATE_TIME)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return DateUtils.toCommonLogFormat(new Date());
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory remoteUser() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.REMOTE_USER)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
                            if (sc == null || !sc.isAuthenticated()) {
                                return null;
                            }
                            return sc.getAuthenticatedAccount().getPrincipal().getName();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory requestedUrl() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.REQUESTED_URL)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getRequestURI();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory threadName() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.THREAD_NAME)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return Thread.currentThread().getName();
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory localServerName() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.equals(DefaultAccessLogTokens.LOCAL_SERVER_NAME)) {
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getRequestHeaders().getFirst(Headers.HOST);
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory incomingHeaders() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.startsWith("%{") && token.endsWith("}i")) {
                    final HttpString headerName = HttpString.tryFromString(token.substring(2, token.length() - 2));
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getRequestHeaders().getFirst(headerName);
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory outgoingHeaders() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.startsWith("%{") && token.endsWith("}o")) {
                    final HttpString headerName = HttpString.tryFromString(token.substring(2, token.length() - 2));
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            return exchange.getResponseHeaders().getFirst(headerName);
                        }
                    };
                }
                return null;
            }
        };
    }

    public static final TokenHandler.Factory cookies() {
        return new TokenHandler.Factory(){

            @Override
            public TokenHandler create(String token) {
                if (token.startsWith("%{") && token.endsWith("}c")) {
                    final String headerName = token.substring(2, token.length() - 2);
                    return new TokenHandler(){

                        @Override
                        public String generateMessage(HttpServerExchange exchange) {
                            Cookie cookie = exchange.getRequestCookies().get(headerName);
                            if (cookie == null) {
                                return null;
                            }
                            return cookie.getValue();
                        }
                    };
                }
                return null;
            }
        };
    }

    private DefaultAccessLogTokens() {
    }
}

