/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpParser;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpTransferEncoding;
import io.undertow.server.ParseState;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class HttpReadListener
implements ChannelListener<StreamSourceChannel> {
    private final StreamSinkChannel responseChannel;
    private ParseState state = new ParseState();
    private HttpServerExchange httpServerExchange;
    private final HttpServerConnection connection;
    private int read = 0;
    private final int maxRequestSize;

    HttpReadListener(StreamSinkChannel responseChannel, StreamSourceChannel requestChannel, HttpServerConnection connection) {
        this.responseChannel = responseChannel;
        this.connection = connection;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
        this.httpServerExchange = new HttpServerExchange(connection, requestChannel, this.responseChannel);
        this.httpServerExchange.addExchangeCompleteListener(new StartNextRequestAction(requestChannel, responseChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        Pooled existing = this.connection.getExtraBytes();
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set((ChannelListener)this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.suspendReads();
                        channel.shutdownReads();
                        StreamSinkChannel responseChannel = this.responseChannel;
                        responseChannel.shutdownWrites();
                        if (!responseChannel.flush()) {
                            responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                            responseChannel.resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                HttpParser.INSTANCE.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                    continue;
                }
                this.read = total = this.read + res;
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            channel.getReadSetter().set(null);
            channel.suspendReads();
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.putAttachment(UndertowOptions.ATTACHMENT_KEY, this.connection.getUndertowOptions());
            try {
                httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
                this.state = null;
                this.httpServerExchange = null;
                this.httpServerExchange = null;
                HttpTransferEncoding.handleRequest(httpServerExchange, this.connection.getRootHandler());
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)channel);
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private static class StartNextRequestAction
    implements ExchangeCompletionListener {
        private StreamSourceChannel requestChannel;
        private StreamSinkChannel responseChannel;

        public StartNextRequestAction(StreamSourceChannel requestChannel, StreamSinkChannel responseChannel) {
            this.requestChannel = requestChannel;
            this.responseChannel = responseChannel;
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            if (exchange.isPersistent() && !exchange.isUpgrade()) {
                StreamSourceChannel channel = this.requestChannel;
                HttpReadListener listener = new HttpReadListener(this.responseChannel, channel, exchange.getConnection());
                if (exchange.getConnection().getExtraBytes() == null) {
                    channel.getReadSetter().set((ChannelListener)listener);
                    channel.resumeReads();
                } else {
                    if (channel.isReadResumed()) {
                        channel.suspendReads();
                    }
                    if (exchange.isInIoThread()) {
                        channel.getIoThread().execute((Runnable)new DoNextRequestRead(listener, channel));
                    } else {
                        Executor executor = exchange.getDispatchExecutor();
                        if (executor == null) {
                            executor = exchange.getConnection().getWorker();
                        }
                        executor.execute(new DoNextRequestRead(listener, channel));
                    }
                }
                this.responseChannel = null;
                this.requestChannel = null;
            }
            nextListener.proceed();
        }

        private static class DoNextRequestRead
        implements Runnable {
            private final HttpReadListener listener;
            private final StreamSourceChannel channel;

            public DoNextRequestRead(HttpReadListener listener, StreamSourceChannel channel) {
                this.listener = listener;
                this.channel = channel;
            }

            @Override
            public void run() {
                this.listener.handleEvent(this.channel);
            }
        }
    }
}

