/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class HeaderMap
implements Iterable<HttpString> {
    private static final int SIZE = 17;
    private static final int SIGN_MASK = Integer.MAX_VALUE;
    private final HeaderEntry[] entries = new HeaderEntry[17];

    @Override
    public Iterator<HttpString> iterator() {
        return new MapIterator();
    }

    public String getFirst(HttpString headerName) {
        Object value = this.getValue(headerName);
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    public String getLast(HttpString headerName) {
        Object value = this.getValue(headerName);
        if (value instanceof List) {
            List list = (List)value;
            return (String)list.get(list.size() - 1);
        }
        return (String)value;
    }

    public List<String> get(HttpString headerName) {
        Object value = this.getValue(headerName);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.singletonList((String)value);
    }

    public void add(HttpString headerName, String headerValue) {
        HeaderEntry entry = this.getEntry(headerName);
        if (entry == null) {
            int pos = (headerName.hashCode() & Integer.MAX_VALUE) % 17;
            HeaderEntry exiting = this.entries[pos];
            entry = new HeaderEntry();
            entry.next = exiting;
            entry.name = headerName;
            entry.value = headerValue;
            this.entries[pos] = entry;
        } else if (entry.value instanceof List) {
            ((List)entry.value).add(headerValue);
        } else {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add((String)entry.value);
            list.add(headerValue);
            entry.value = list;
        }
    }

    public void add(HttpString headerName, long headerValue) {
        this.add(headerName, Long.toString(headerValue));
    }

    public void addAll(HttpString headerName, Collection<String> headerValues) {
        HeaderEntry entry = this.getEntry(headerName);
        if (entry == null) {
            int pos = (headerName.hashCode() & Integer.MAX_VALUE) % 17;
            HeaderEntry exiting = this.entries[pos];
            entry = new HeaderEntry();
            entry.next = exiting;
            entry.name = headerName;
            entry.value = new ArrayList<String>(headerValues);
            this.entries[pos] = entry;
        } else if (entry.value instanceof List) {
            ((List)entry.value).addAll(headerValues);
        } else {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add((String)entry.value);
            list.addAll(headerValues);
            entry.value = list;
        }
    }

    public void clear() {
        for (int i = 0; i < 17; ++i) {
            this.entries[i] = null;
        }
    }

    public Collection<HttpString> getHeaderNames() {
        HashSet<HttpString> ret = new HashSet<HttpString>();
        for (HttpString i : this) {
            ret.add(i);
        }
        return ret;
    }

    public void put(HttpString headerName, String headerValue) {
        HeaderEntry entry = this.getEntry(headerName);
        if (entry == null) {
            int pos = (headerName.hashCode() & Integer.MAX_VALUE) % 17;
            HeaderEntry exiting = this.entries[pos];
            entry = new HeaderEntry();
            entry.next = exiting;
            entry.name = headerName;
            entry.value = headerValue;
            this.entries[pos] = entry;
        } else {
            entry.value = headerValue;
        }
    }

    public void put(HttpString headerName, long headerValue) {
        this.put(headerName, Long.toString(headerValue));
    }

    public Collection<String> remove(HttpString headerName) {
        int pos = (headerName.hashCode() & Integer.MAX_VALUE) % 17;
        HeaderEntry entry = this.entries[pos];
        if (entry == null) {
            return null;
        }
        if (entry.name.equals(headerName)) {
            this.entries[pos] = entry.next;
            if (entry.value instanceof List) {
                return (Collection)entry.value;
            }
            return Collections.singletonList(entry.value);
        }
        HeaderEntry prev = entry;
        entry = entry.next;
        while (entry != null) {
            if (entry.name.equals(headerName)) {
                prev.next = entry.next;
                if (entry.value instanceof List) {
                    return (Collection)entry.value;
                }
                return Collections.singletonList(entry.value);
            }
            prev = entry;
            entry = entry.next;
        }
        return null;
    }

    public void lock() {
    }

    public boolean contains(HttpString headerName) {
        HeaderEntry value = this.getEntry(headerName);
        return value != null;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "HeaderMap{values=" + this.entries + '}';
    }

    private Object getValue(HttpString headerName) {
        HeaderEntry entry = this.getEntry(headerName);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    private HeaderEntry getEntry(HttpString headerName) {
        int pos = (headerName.hashCode() & Integer.MAX_VALUE) % 17;
        HeaderEntry entry = this.entries[pos];
        while (entry != null) {
            if (entry.name.equals(headerName)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private class MapIterator
    implements Iterator<HttpString> {
        private int pos = 0;
        private HeaderEntry current;

        MapIterator() {
            while (this.pos < HeaderMap.this.entries.length && HeaderMap.this.entries[this.pos] == null) {
                ++this.pos;
            }
            if (this.pos < HeaderMap.this.entries.length) {
                this.current = HeaderMap.this.entries[this.pos];
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public HttpString next() {
            HttpString toReturn = this.current.name;
            if (this.current.next != null) {
                this.current = this.current.next;
            } else {
                do {
                    ++this.pos;
                } while (this.pos < HeaderMap.this.entries.length && HeaderMap.this.entries[this.pos] == null);
                this.current = this.pos < HeaderMap.this.entries.length ? HeaderMap.this.entries[this.pos] : null;
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static final class HeaderEntry {
        HeaderEntry next;
        Object value;
        HttpString name;

        private HeaderEntry() {
        }
    }
}

