/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.api;

public final class CloseReason {
    public static final int NORMAL_CLOSURE = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1003;
    public static final int MSG_CONTAINS_INVALID_DATA = 1007;
    public static final int MSG_VIOLATES_POLICY = 1008;
    public static final int MSG_TOO_BIG = 1009;
    public static final int MISSING_EXTENSIONS = 1010;
    public static final int UNEXPECTED_ERROR = 1011;
    public static final CloseReason NONE = null;
    public static final CloseReason NORMAL = new CloseReason(1000);
    private final int code;
    private final String reason;

    public CloseReason(int code) {
        this(code, null);
    }

    public CloseReason(int code, String reason) {
        if (!CloseReason.isValid(code)) {
            throw new IllegalArgumentException("Invalid close status code " + code);
        }
        this.code = code;
        this.reason = reason;
    }

    public int getStatusCode() {
        return this.code;
    }

    public String getReasonText() {
        return this.reason;
    }

    public static boolean isValid(int code) {
        return !(code >= 0 && code <= 999 || code >= 1004 && code <= 1006) && (code < 1012 || code > 2999);
    }
}

