/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.MalformedMessageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

public class MultipartParser {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};

    public static ParseState beginParse(Pool<ByteBuffer> bufferPool, PartHandler handler, byte[] boundary) {
        byte[] boundaryToken = new byte[boundary.length + BOUNDARY_PREFIX.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, boundaryToken, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, boundaryToken, BOUNDARY_PREFIX.length, boundary.length);
        return new ParseState(bufferPool, handler, boundaryToken);
    }

    private static class QuotedPrintableEncoding
    implements Encoding {
        private final Pool<ByteBuffer> bufferPool;
        boolean equalsSeen;
        byte firstCharacter;

        private QuotedPrintableEncoding(Pool<ByteBuffer> bufferPool) {
            this.bufferPool = bufferPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            boolean equalsSeen = this.equalsSeen;
            byte firstCharacter = this.firstCharacter;
            Pooled resource = this.bufferPool.allocate();
            ByteBuffer buf = (ByteBuffer)resource.getResource();
            try {
                while (rawData.hasRemaining()) {
                    byte b = rawData.get();
                    if (equalsSeen) {
                        if (firstCharacter == 0) {
                            if (b == 10 || b == 13) {
                                equalsSeen = false;
                                continue;
                            }
                            firstCharacter = b;
                            continue;
                        }
                        int result = Integer.parseInt("" + (char)firstCharacter, 16);
                        result <<= 4;
                        buf.put((byte)(result += Integer.parseInt("" + (char)b, 16)));
                        equalsSeen = false;
                        firstCharacter = 0;
                        continue;
                    }
                    if (b == 61) {
                        equalsSeen = true;
                        continue;
                    }
                    buf.put(b);
                    if (buf.hasRemaining()) continue;
                    buf.flip();
                    handler.data(buf);
                    buf.clear();
                }
                buf.flip();
                handler.data(buf);
            }
            finally {
                resource.free();
                this.equalsSeen = equalsSeen;
                this.firstCharacter = firstCharacter;
            }
        }
    }

    private static class Base64Encoding
    implements Encoding {
        private final FlexBase64.Decoder decoder = FlexBase64.createDecoder();
        private final Pool<ByteBuffer> bufferPool;

        private Base64Encoding(Pool<ByteBuffer> bufferPool) {
            this.bufferPool = bufferPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            Pooled resource = this.bufferPool.allocate();
            ByteBuffer buf = (ByteBuffer)resource.getResource();
            try {
                do {
                    buf.clear();
                    try {
                        this.decoder.decode(rawData, buf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    buf.flip();
                    handler.data(buf);
                } while (rawData.hasRemaining());
            }
            finally {
                resource.free();
            }
        }
    }

    private static class IdentityEncoding
    implements Encoding {
        private IdentityEncoding() {
        }

        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            handler.data(rawData);
            rawData.clear();
        }
    }

    private static interface Encoding {
        public void handle(PartHandler var1, ByteBuffer var2) throws IOException;
    }

    public static class ParseState {
        private final Pool<ByteBuffer> bufferPool;
        private final PartHandler partHandler;
        private final byte[] boundary;
        private volatile int state = 0;
        private volatile int subState = Integer.MAX_VALUE;
        private volatile StringBuilder currentString = null;
        private volatile String currentHeaderName = null;
        private volatile HeaderMap headers;
        private volatile Encoding encodingHandler;

        public ParseState(Pool<ByteBuffer> bufferPool, PartHandler partHandler, byte[] boundary) {
            this.bufferPool = bufferPool;
            this.partHandler = partHandler;
            this.boundary = boundary;
        }

        public void parse(ByteBuffer buffer) throws IOException {
            block7: while (buffer.hasRemaining()) {
                switch (this.state) {
                    case 0: {
                        this.preamble(buffer);
                        continue block7;
                    }
                    case 1: {
                        this.headerName(buffer);
                        continue block7;
                    }
                    case 2: {
                        this.headerValue(buffer);
                        continue block7;
                    }
                    case 3: {
                        this.entity(buffer);
                        continue block7;
                    }
                    case -1: {
                        return;
                    }
                }
                throw new IllegalStateException("" + this.state);
            }
        }

        private void preamble(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (this.subState == Integer.MAX_VALUE) {
                        this.subState = this.boundary[2] == b ? 2 : 0;
                    }
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        this.subState = 1;
                        continue;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b != 13) continue;
                    this.subState = -2;
                    continue;
                }
                if (this.subState != -2) continue;
                if (b == 10) {
                    this.subState = 0;
                    this.state = 1;
                    this.headers = new HeaderMap();
                    return;
                }
                this.subState = -1;
            }
        }

        private void headerName(ByteBuffer buffer) throws MalformedMessageException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b == 58) {
                    if (this.currentString == null || this.subState != 0) {
                        throw new MalformedMessageException();
                    }
                    this.currentHeaderName = this.currentString.toString();
                    this.currentString.setLength(0);
                    this.subState = 0;
                    this.state = 2;
                    return;
                }
                if (b == 13) {
                    if (this.currentString != null) {
                        throw new MalformedMessageException();
                    }
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.currentString != null || this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.state = 3;
                    this.subState = 0;
                    this.partHandler.beginPart(this.headers);
                    String encoding = this.headers.getFirst(Headers.CONTENT_TRANSFER_ENCODING);
                    this.encodingHandler = encoding == null ? new IdentityEncoding() : (encoding.toLowerCase().equals("base64") ? new Base64Encoding(this.bufferPool) : (encoding.toLowerCase().equals("quoted-printable") ? new QuotedPrintableEncoding(this.bufferPool) : new IdentityEncoding()));
                    this.headers = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                if (this.currentString == null) {
                    this.currentString = new StringBuilder();
                }
                this.currentString.append((char)b);
            }
        }

        private void headerValue(ByteBuffer buffer) throws MalformedMessageException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b == 13) {
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.headers.put(new HttpString(this.currentHeaderName.trim()), this.currentString.toString().trim());
                    this.state = 1;
                    this.subState = 0;
                    this.currentString = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                this.currentString.append((char)b);
            }
        }

        private void entity(ByteBuffer buffer) throws IOException {
            int pos = buffer.position();
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        ByteBuffer retBuffer = buffer.duplicate();
                        retBuffer.position(pos);
                        retBuffer.limit(Math.max(buffer.position() - this.boundary.length, 0));
                        this.encodingHandler.handle(this.partHandler, retBuffer);
                        this.partHandler.endPart();
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        this.subState = 1;
                        continue;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b == 13) {
                        this.subState = -2;
                        continue;
                    }
                    if (b != 45) continue;
                    this.subState = -3;
                    continue;
                }
                if (this.subState == -2) {
                    if (b == 10) {
                        this.subState = 0;
                        this.state = 1;
                        this.headers = new HeaderMap();
                        return;
                    }
                    if (b == 45) {
                        this.subState = -3;
                        continue;
                    }
                    this.subState = -1;
                    continue;
                }
                if (this.subState != -3) continue;
                if (b == 45) {
                    this.state = -1;
                    return;
                }
                this.subState = -1;
            }
            ByteBuffer retBuffer = buffer.duplicate();
            retBuffer.position(pos);
            this.partHandler.data(retBuffer);
        }

        public boolean isComplete() {
            return this.state == -1;
        }
    }

    public static interface PartHandler {
        public void beginPart(HeaderMap var1);

        public void data(ByteBuffer var1) throws IOException;

        public void endPart();
    }
}

