/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.UndertowLogger;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.http.HttpClientExchange;
import io.undertow.client.http.HttpRequestConduit;
import io.undertow.client.http.HttpResponseBuilder;
import io.undertow.client.http.HttpResponseParser;
import io.undertow.client.http.ResponseParseState;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FixedLengthStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class HttpClientConnection
extends AbstractAttachable
implements Closeable,
ClientConnection {
    public final ConduitListener<StreamSinkConduit> requestFinishListener = new ConduitListener<StreamSinkConduit>(){

        @Override
        public void handleEvent(StreamSinkConduit channel) {
            HttpClientConnection.this.currentRequest.terminateRequest();
        }
    };
    public final ConduitListener<StreamSourceConduit> responseFinishedListener = new ConduitListener<StreamSourceConduit>(){

        @Override
        public void handleEvent(StreamSourceConduit channel) {
            HttpClientConnection.this.currentRequest.terminateResponse();
        }
    };
    private final Deque<HttpClientExchange> pendingQueue = new ArrayDeque<HttpClientExchange>();
    private HttpClientExchange currentRequest;
    private HttpResponseBuilder pendingResponse;
    private final OptionMap options;
    private final StreamConnection connection;
    private final PushBackStreamSourceConduit pushBackStreamSourceConduit;
    private final ClientReadListener clientReadListener = new ClientReadListener();
    private final Pool<ByteBuffer> bufferPool;
    private final StreamSinkConduit originalSinkConduit;
    private static final int UPGRADED = 0x10000000;
    private static final int UPGRADE_REQUESTED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private int state;
    private final ChannelListener.SimpleSetter<HttpClientConnection> closeSetter = new ChannelListener.SimpleSetter();

    HttpClientConnection(StreamConnection connection, OptionMap options, Pool<ByteBuffer> bufferPool) {
        this.options = options;
        this.connection = connection;
        this.pushBackStreamSourceConduit = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
        this.connection.getSourceChannel().setConduit((StreamSourceConduit)this.pushBackStreamSourceConduit);
        this.bufferPool = bufferPool;
        this.originalSinkConduit = connection.getSinkChannel().getConduit();
        connection.getCloseSetter().set((ChannelListener)new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                HttpClientConnection.this.state |= Integer.MIN_VALUE;
                ChannelListeners.invokeChannelListener((Channel)HttpClientConnection.this, (ChannelListener)HttpClientConnection.this.closeSetter.get());
            }
        });
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    StreamConnection getConnection() {
        return this.connection;
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.connection.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends HttpClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.connection.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen() && Bits.allAreClear((int)this.state, (int)-1073741824);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.connection.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.connection.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.connection.setOption(option, value);
    }

    @Override
    public boolean isUpgraded() {
        return Bits.anyAreSet((int)this.state, (int)0x30000000);
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        if (Bits.anyAreSet((int)this.state, (int)-268435456)) {
            throw UndertowClientMessages.MESSAGES.invalidConnectionState();
        }
        HttpClientExchange httpClientExchange = new HttpClientExchange(clientCallback, request, this);
        if (this.currentRequest == null) {
            this.inititateRequest(httpClientExchange);
        } else {
            this.pendingQueue.add(httpClientExchange);
        }
    }

    private void inititateRequest(HttpClientExchange httpClientExchange) {
        this.currentRequest = httpClientExchange;
        this.pendingResponse = new HttpResponseBuilder();
        ClientRequest request = httpClientExchange.getRequest();
        String connectionString = request.getRequestHeaders().getFirst(Headers.CONNECTION);
        if (connectionString != null) {
            HttpString connectionHttpString = new HttpString(connectionString);
            if (connectionHttpString.equals(Headers.CLOSE)) {
                this.state |= 0x40000000;
            } else if (connectionHttpString.equals(Headers.UPGRADE)) {
                this.state |= 0x20000000;
            }
        } else if (request.getProtocol() != Protocols.HTTP_1_1) {
            this.state |= 0x40000000;
        }
        if (request.getRequestHeaders().contains(Headers.UPGRADE)) {
            this.state |= 0x20000000;
        }
        ConduitStreamSourceChannel sourceChannel = this.connection.getSourceChannel();
        sourceChannel.setReadListener((ChannelListener)this.clientReadListener);
        sourceChannel.resumeReads();
        ConduitStreamSinkChannel sinkChannel = this.connection.getSinkChannel();
        Object conduit = this.originalSinkConduit;
        conduit = new HttpRequestConduit((StreamSinkConduit)conduit, this.bufferPool, request);
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        boolean hasContent = true;
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                conduit = new FixedLengthStreamSinkConduit((StreamSinkConduit)conduit, length, false, false, (ConduitListener<? super FixedLengthStreamSinkConduit>)this.requestFinishListener);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                return;
            }
        } else if (transferEncodingString != null) {
            if (!transferEncodingString.toLowerCase().contains(Headers.CHUNKED.toString())) {
                this.handleError(UndertowClientMessages.MESSAGES.unknownTransferEncoding(transferEncodingString));
                return;
            }
            conduit = new ChunkedStreamSinkConduit((StreamSinkConduit)conduit, false, false, (ConduitListener<? super ChunkedStreamSinkConduit>)this.requestFinishListener, httpClientExchange);
        } else {
            conduit = new FixedLengthStreamSinkConduit((StreamSinkConduit)conduit, 0L, false, false, (ConduitListener<? super FixedLengthStreamSinkConduit>)this.requestFinishListener);
            hasContent = false;
        }
        sinkChannel.setConduit(conduit);
        httpClientExchange.getReadyCallback().completed(httpClientExchange);
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.setWriteListener(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<ConduitStreamSinkChannel>(){

                        public void handleException(ConduitStreamSinkChannel channel, IOException exception) {
                            HttpClientConnection.this.handleError(exception);
                        }
                    }));
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        } else if (!sinkChannel.isWriteResumed()) {
            try {
                if (!sinkChannel.flush()) {
                    sinkChannel.setWriteListener((ChannelListener)new ChannelListener<ConduitStreamSinkChannel>(){

                        public void handleEvent(ConduitStreamSinkChannel channel) {
                            try {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                            }
                            catch (IOException e) {
                                HttpClientConnection.this.handleError(e);
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(IOException exception) {
        this.currentRequest.setFailed(exception);
        IoUtils.safeClose((Closeable)this.connection);
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        if (Bits.allAreSet((int)this.state, (int)-805306368)) {
            throw new IOException(UndertowClientMessages.MESSAGES.connectionClosed());
        }
        this.state |= 0x10000000;
        return this.connection;
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)Integer.MIN_VALUE)) {
            return;
        }
        this.state |= 0xC0000000;
        this.connection.close();
    }

    public void requestDone() {
        this.connection.getSinkChannel().setConduit(this.originalSinkConduit);
        this.connection.getSourceChannel().setConduit((StreamSourceConduit)this.pushBackStreamSourceConduit);
        this.connection.getSinkChannel().suspendWrites();
        this.connection.getSinkChannel().setWriteListener(null);
        if (Bits.anyAreSet((int)this.state, (int)0x40000000)) {
            this.currentRequest = null;
            this.state |= Integer.MIN_VALUE;
            IoUtils.safeClose((Closeable)this.connection);
        } else if (Bits.anyAreSet((int)this.state, (int)0x20000000)) {
            this.connection.getSourceChannel().suspendReads();
            this.currentRequest = null;
            return;
        }
        this.currentRequest = null;
        HttpClientExchange next = this.pendingQueue.poll();
        if (next == null) {
            this.connection.getSourceChannel().setReadListener((ChannelListener)this.clientReadListener);
            this.connection.getSourceChannel().resumeReads();
        } else {
            this.inititateRequest(next);
        }
    }

    private void prepareResponseChannel(ClientResponse response, ClientExchange exchange) {
        String encoding = response.getResponseHeaders().getLast(Headers.TRANSFER_ENCODING);
        boolean chunked = encoding != null && Headers.CHUNKED.equals(new HttpString(encoding));
        String length = response.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (exchange.getRequest().getMethod().equals(Methods.HEAD)) {
            this.connection.getSourceChannel().setConduit((StreamSourceConduit)new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), 0L, this.responseFinishedListener));
        } else if (chunked) {
            this.connection.getSourceChannel().setConduit((StreamSourceConduit)new ChunkedStreamSourceConduit(this.connection.getSourceChannel().getConduit(), this.pushBackStreamSourceConduit, this.bufferPool, this.responseFinishedListener, exchange));
        } else if (length != null) {
            try {
                long contentLength = Long.parseLong(length);
                this.connection.getSourceChannel().setConduit((StreamSourceConduit)new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), contentLength, this.responseFinishedListener));
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                throw e;
            }
        } else if (response.getProtocol().equals(Protocols.HTTP_1_1)) {
            this.connection.getSourceChannel().setConduit((StreamSourceConduit)new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), 0L, this.responseFinishedListener));
        } else {
            this.state |= 0x40000000;
        }
    }

    class ClientReadListener
    implements ChannelListener<StreamSourceChannel> {
        ClientReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleEvent(StreamSourceChannel channel) {
            HttpResponseBuilder builder = HttpClientConnection.this.pendingResponse;
            Pooled pooled = HttpClientConnection.this.bufferPool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            boolean free = true;
            try {
                if (builder == null) {
                    buffer.clear();
                    try {
                        int res = channel.read(buffer);
                        if (res == -1) {
                            UndertowLogger.CLIENT_LOGGER.debugf("Connection to %s was closed by the target server", HttpClientConnection.this.connection.getPeerAddress());
                            IoUtils.safeClose((Closeable)HttpClientConnection.this);
                            return;
                        }
                        if (res == 0) return;
                        UndertowLogger.CLIENT_LOGGER.debugf("Target server %s sent unexpected data when no request pending, closing connection", HttpClientConnection.this.connection.getPeerAddress());
                        IoUtils.safeClose((Closeable)HttpClientConnection.this);
                        return;
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)HttpClientConnection.this.connection);
                    }
                    return;
                }
                ResponseParseState state = builder.getParseState();
                do {
                    int res;
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (!free) return;
                        pooled.free();
                        return;
                    }
                    if (res == 0) {
                        if (channel.isReadResumed()) return;
                        channel.getReadSetter().set((ChannelListener)this);
                        channel.resumeReads();
                        return;
                    }
                    if (res == -1) {
                        try {
                            channel.suspendReads();
                            channel.shutdownReads();
                            ConduitStreamSinkChannel requestChannel = HttpClientConnection.this.connection.getSinkChannel();
                            requestChannel.shutdownWrites();
                            if (!requestChannel.flush()) {
                                requestChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                requestChannel.resumeWrites();
                            }
                            HttpClientConnection.this.currentRequest.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                            return;
                        }
                        catch (IOException e) {
                            if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                                UndertowLogger.CLIENT_LOGGER.debugf(e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                            }
                            HttpClientConnection.this.currentRequest.setFailed(e);
                            IoUtils.safeClose((Closeable)channel);
                            if (!free) return;
                            pooled.free();
                            return;
                        }
                    }
                    buffer.flip();
                    HttpResponseParser.INSTANCE.handle(buffer, state, builder);
                    if (!buffer.hasRemaining()) continue;
                    free = false;
                    HttpClientConnection.this.pushBackStreamSourceConduit.pushBack(pooled);
                } while (!state.isComplete());
                ClientResponse response = builder.build();
                String connectionString = response.getResponseHeaders().getFirst(Headers.CONNECTION);
                if (!(!Bits.anyAreSet((int)HttpClientConnection.this.state, (int)0x20000000) || connectionString != null && Headers.UPGRADE.equalToString(connectionString) || response.getResponseHeaders().contains(Headers.UPGRADE))) {
                    HttpClientConnection.this.state &= -536870913;
                }
                if (connectionString != null && HttpString.tryFromString(connectionString).equals(Headers.CLOSE)) {
                    HttpClientConnection.this.state |= 0x40000000;
                }
                if (builder.getStatusCode() == 100) {
                    HttpClientConnection.this.pendingResponse = new HttpResponseBuilder();
                    HttpClientConnection.this.currentRequest.setContinueResponse(response);
                    return;
                } else {
                    HttpClientConnection.this.prepareResponseChannel(response, HttpClientConnection.this.currentRequest);
                    channel.getReadSetter().set(null);
                    channel.suspendReads();
                    HttpClientConnection.this.pendingResponse = null;
                    HttpClientConnection.this.currentRequest.setResponse(response);
                }
                return;
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)HttpClientConnection.this.connection);
                HttpClientConnection.this.currentRequest.setFailed(new IOException(e));
                return;
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

