/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.client.HttpClientConnectionImpl;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientRequestImpl;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpContinueNotification;
import io.undertow.client.ResponseParseState;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.OptionMap;
import org.xnio.Result;
import org.xnio.channels.Configurable;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSourceChannelWrappingConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class PendingHttpRequest {
    private final ResponseParseState parseState = new ResponseParseState();
    private int statusCode;
    private HttpString protocol;
    private String reasonPhrase;
    private final HeaderMap responseHeaders = new HeaderMap();
    private final boolean pipeline;
    private final HttpClientRequestImpl request;
    private final HttpClientConnectionImpl connection;
    private final Result<HttpClientResponse> result;
    private final HttpContinueNotification continueHandler;
    private volatile int state = 1;
    private static final AtomicIntegerFieldUpdater<PendingHttpRequest> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(PendingHttpRequest.class, "state");
    private static final int INITIAL = 1;
    private static final int SENDING_REQUEST = 4;
    private static final int RECEIVING = 8;
    private static final int COMPLETED = 16;
    private static final int OPEN_GATE = 0x20000000;
    private static final int FLUSH_HEADERS = 0x40000000;
    private static final int SHUTDOWN_WRITES = Integer.MIN_VALUE;

    PendingHttpRequest(HttpClientRequestImpl request, HttpClientConnectionImpl connection, boolean keepAlive, boolean hasContent, boolean expectContinue, boolean pipeline, Result<HttpClientResponse> result, HttpContinueNotification handler) {
        this.request = request;
        this.connection = connection;
        this.pipeline = pipeline;
        this.result = result;
        this.continueHandler = handler;
        if (!keepAlive) {
            this.state |= Integer.MIN_VALUE;
        }
        if (!hasContent || expectContinue) {
            this.state |= 0x40000000;
        }
        if (!expectContinue) {
            this.state |= 0x20000000;
        }
    }

    public ResponseParseState getParseState() {
        return this.parseState;
    }

    HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    String getReasonPhrase() {
        return this.reasonPhrase;
    }

    void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    HttpString getProtocol() {
        return this.protocol;
    }

    void setProtocol(HttpString protocol) {
        this.protocol = protocol;
    }

    HttpClientRequest getRequest() {
        return this.request;
    }

    protected void setCancelled() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        this.result.setCancelled();
    }

    protected void setFailed(IOException e) {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        this.result.setException(e);
    }

    protected void startSendingRequest() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet((int)(oldVal = this.state), (int)20)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 4));
        boolean openGate = Bits.allAreSet((int)newVal, (int)0x20000000);
        if (openGate) {
            this.request.openGate();
        }
        if (Bits.allAreSet((int)newVal, (int)0x40000000)) {
            this.request.flushHeaders(this, openGate);
        }
        if (Bits.allAreSet((int)newVal, (int)12)) {
            if (Bits.allAreSet((int)newVal, (int)Integer.MIN_VALUE)) {
                try {
                    this.connection.requestConnectionClose();
                }
                catch (IOException e) {
                    UndertowLogger.CLIENT_LOGGER.debugf(e, "failed to shutdown writes", new Object[0]);
                }
            }
            this.connection.sendingCompleted(this);
        }
    }

    protected void requestSent() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet((int)(oldVal = this.state), (int)24)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 8));
        if (Bits.allAreSet((int)newVal, (int)12)) {
            if (Bits.allAreSet((int)newVal, (int)Integer.MIN_VALUE)) {
                try {
                    this.connection.requestConnectionClose();
                }
                catch (IOException e) {
                    UndertowLogger.CLIENT_LOGGER.debugf(e, "failed to shutdown writes", new Object[0]);
                }
            }
            this.connection.sendingCompleted(this);
        }
    }

    protected void completed(boolean close) {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        if (close) {
            try {
                this.connection.requestConnectionClose();
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debugf(e, "failed to shutdown reads and writes", new Object[0]);
            }
        }
        this.connection.requestCompleted(this);
    }

    void handleResponseComplete(final HttpClientConnectionImpl connection, PushBackStreamChannel channel) {
        assert (this.parseState.isComplete());
        assert (Bits.allAreClear((int)this.state, (int)16));
        UndertowLogger.CLIENT_LOGGER.tracef("reading response headers complete for %s", this);
        if (this.statusCode == 100) {
            if (this.continueHandler != null) {
                this.continueHandler.handleContinue(new HttpContinueNotification.ContinueContext(){

                    @Override
                    public void done() {
                        PendingHttpRequest.this.request.openGate();
                        ((PendingHttpRequest)PendingHttpRequest.this).parseState.state = 0;
                        ((PendingHttpRequest)PendingHttpRequest.this).parseState.stringBuilder.setLength(0);
                        ((PendingHttpRequest)PendingHttpRequest.this).parseState.pos = 0;
                        connection.doReadResponse(PendingHttpRequest.this);
                    }
                });
            } else {
                this.request.openGate();
                this.parseState.state = 0;
                this.parseState.stringBuilder.setLength(0);
                this.parseState.pos = 0;
                connection.doReadResponse(this);
            }
            return;
        }
        HeaderMap headers = this.getResponseHeaders();
        boolean http11 = Protocols.HTTP_1_1.equals(this.getProtocol());
        String connectionHeader = headers.getFirst(Headers.CONNECTION);
        boolean closeConnection = http11 ? (connectionHeader == null ? false : Headers.CLOSE.equals(new HttpString(connectionHeader))) : (Protocols.HTTP_1_0.equals(this.getProtocol()) ? (connectionHeader == null ? true : !Headers.KEEP_ALIVE.equals(new HttpString(connectionHeader))) : true);
        boolean noContent = false;
        int responseCode = this.statusCode;
        if (responseCode >= 100 && responseCode < 200 || responseCode == 204 || responseCode == 304) {
            noContent = true;
        }
        if (!noContent && "HEAD".equals(this.request.getMethod())) {
            noContent = true;
        }
        Object conduit = new StreamSourceChannelWrappingConduit((StreamSourceChannel)channel);
        long contentLength = -1L;
        if (noContent) {
            conduit = new EmptyStreamSourceConduit(channel.getIoThread());
        } else {
            String transferEncoding = Headers.IDENTITY.toString();
            if (headers.contains(Headers.TRANSFER_ENCODING)) {
                transferEncoding = headers.getLast(Headers.TRANSFER_ENCODING);
            } else if (http11 && !headers.contains(Headers.CONTENT_LENGTH)) {
                transferEncoding = Headers.CHUNKED.toString();
            }
            if (!transferEncoding.equals(Headers.IDENTITY.toString())) {
                conduit = new ChunkedStreamSourceConduit((StreamSourceConduit)conduit, channel, connection.getBufferPool(), this.getFinishListener(closeConnection), this.request);
            } else if (headers.contains(Headers.CONTENT_LENGTH)) {
                contentLength = Long.parseLong(headers.getFirst(Headers.CONTENT_LENGTH));
                if (contentLength == 0L) {
                    conduit = new EmptyStreamSourceConduit(channel.getIoThread());
                    noContent = true;
                } else {
                    conduit = new FixedLengthStreamSourceConduit((StreamSourceConduit)conduit, contentLength, this.getFinishListener(closeConnection));
                }
            } else {
                closeConnection = true;
            }
        }
        ConduitStreamSourceChannel responseChannel = new ConduitStreamSourceChannel((Configurable)channel, (StreamSourceConduit)conduit);
        HttpClientResponse response = new HttpClientResponse(this, this.request, contentLength, (StreamSourceChannel)responseChannel);
        this.result.setResult((Object)response);
        if (noContent) {
            this.completed(closeConnection);
        }
    }

    boolean allowPipeline() {
        return this.pipeline;
    }

    ConduitListener<StreamSourceConduit> getFinishListener(final boolean closeConnection) {
        return new ConduitListener<StreamSourceConduit>(){

            @Override
            public void handleEvent(StreamSourceConduit conduit) {
                PendingHttpRequest.this.completed(closeConnection);
            }
        };
    }

    private static long maxEntitySize(OptionMap options) {
        return options.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
    }
}

