/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class FixedPayloadFrameSourceChannel
extends StreamSourceFrameChannel {
    private long readBytes;
    private final ChannelFunction[] functions;

    protected FixedPayloadFrameSourceChannel(WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl, StreamSourceChannel channel, WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize, int rsv, boolean finalFragment, ChannelFunction ... functions) {
        super(streamSourceChannelControl, channel, wsChannel, type, payloadSize, rsv, finalFragment);
        this.functions = functions;
    }

    @Override
    protected final long transferTo0(long position, long count, FileChannel target) throws IOException {
        long r;
        long toRead = this.bytesToRead();
        if (toRead < 1L) {
            return -1L;
        }
        if (toRead < count) {
            count = toRead;
        }
        if ((r = this.functions != null && this.functions.length > 0 ? this.channel.transferTo(position, count, (FileChannel)new ChannelFunctionFileChannel(target, this.functions)) : this.channel.transferTo(position, count, target)) > 0L) {
            this.readBytes += r;
        }
        return r;
    }

    @Override
    protected final long transferTo0(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long toRead = this.bytesToRead();
        if (toRead < 1L) {
            return -1L;
        }
        if (toRead < count) {
            count = toRead;
        }
        return WebSocketUtils.transfer((ReadableByteChannel)((Object)this), count, throughBuffer, (WritableByteChannel)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int read0(ByteBuffer dst) throws IOException {
        long toRead = this.bytesToRead();
        if (toRead < 1L) {
            return -1;
        }
        int position = dst.position();
        int old = dst.limit();
        try {
            int r;
            if (toRead < (long)dst.remaining()) {
                dst.limit(dst.position() + (int)toRead);
            }
            if ((r = this.channel.read(dst)) > 0) {
                this.readBytes += (long)r;
                this.afterRead(dst, position, r);
            }
            int n = r;
            return n;
        }
        finally {
            dst.limit(old);
        }
    }

    @Override
    protected final long read0(ByteBuffer[] dsts) throws IOException {
        return this.read0(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long read0(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long l;
        long toRead = this.bytesToRead();
        if (toRead < 1L) {
            return -1L;
        }
        Bounds[] old = new Bounds[length];
        int used = 0;
        long remaining = toRead;
        for (int i = offset; i < length; ++i) {
            ByteBuffer dst = dsts[i];
            old[i - offset] = new Bounds(dst.position(), dst.limit());
            int bufferRemaining = dsts[i].remaining();
            if ((long)(used += bufferRemaining) > remaining) {
                dsts[i].limit((int)remaining);
            }
            remaining = (remaining -= (long)bufferRemaining) < 0L ? 0L : remaining;
        }
        try {
            long b = this.channel.read(dsts, offset, length);
            if (b > 0L) {
                this.readBytes += b;
                for (int i = offset; i < length; ++i) {
                    ByteBuffer dst = dsts[i];
                    int oldPos = old[i - offset].position;
                    this.afterRead(dst, oldPos, dst.position() - oldPos);
                }
            }
            l = b;
        }
        catch (Throwable throwable) {
            for (int i = offset; i < length; ++i) {
                dsts[i].limit(old[i - offset].limit);
            }
            throw throwable;
        }
        for (int i = offset; i < length; ++i) {
            dsts[i].limit(old[i - offset].limit);
        }
        return l;
    }

    private long bytesToRead() {
        return this.getPayloadSize() - this.readBytes;
    }

    @Override
    protected final boolean isComplete() {
        assert (this.readBytes <= this.getPayloadSize());
        return this.readBytes == this.getPayloadSize();
    }

    protected void afterRead(ByteBuffer buffer, int position, int length) throws IOException {
        for (ChannelFunction func : this.functions) {
            func.afterRead(buffer, position, length);
        }
    }

    @Override
    protected void complete() throws IOException {
        if (this.isFinalFragment()) {
            for (ChannelFunction func : this.functions) {
                func.complete();
            }
        }
        super.complete();
    }

    private static class Bounds {
        final int position;
        final int limit;

        Bounds(int position, int limit) {
            this.position = position;
            this.limit = limit;
        }
    }
}

