/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.ServerConnection;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.LinkedList;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public abstract class AbstractServerConnection
extends ServerConnection {
    protected final StreamConnection channel;
    protected final CloseSetter closeSetter;
    protected final Pool<ByteBuffer> bufferPool;
    protected final HttpHandler rootHandler;
    protected final OptionMap undertowOptions;
    protected final StreamSourceConduit originalSourceConduit;
    protected final StreamSinkConduit originalSinkConduit;
    protected final List<ServerConnection.CloseListener> closeListeners = new LinkedList<ServerConnection.CloseListener>();
    private final int bufferSize;
    protected Pooled<ByteBuffer> extraBytes;

    public AbstractServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.closeSetter = new CloseSetter();
        if (channel != null) {
            this.originalSinkConduit = channel.getSinkChannel().getConduit();
            this.originalSourceConduit = channel.getSourceChannel().getConduit();
            channel.setCloseListener((ChannelListener)this.closeSetter);
        } else {
            this.originalSinkConduit = null;
            this.originalSourceConduit = null;
        }
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public StreamConnection getChannel() {
        return this.channel;
    }

    public ChannelListener.Setter<ServerConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.channel.setOption(option, value);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public Pooled<ByteBuffer> getExtraBytes() {
        return this.extraBytes;
    }

    public void setExtraBytes(Pooled<ByteBuffer> extraBytes) {
        this.extraBytes = extraBytes;
    }

    public StreamSourceConduit getOriginalSourceConduit() {
        return this.originalSourceConduit;
    }

    public StreamSinkConduit getOriginalSinkConduit() {
        return this.originalSinkConduit;
    }

    public ConduitState resetChannel() {
        ConduitState ret = new ConduitState(this.channel.getSinkChannel().getConduit(), this.channel.getSourceChannel().getConduit());
        this.channel.getSinkChannel().setConduit(this.originalSinkConduit);
        this.channel.getSourceChannel().setConduit(this.originalSourceConduit);
        return ret;
    }

    public void clearChannel() {
        this.channel.getSinkChannel().setConduit(this.originalSinkConduit);
        this.channel.getSourceChannel().setConduit(this.originalSourceConduit);
    }

    public void restoreChannel(ConduitState state) {
        this.channel.getSinkChannel().setConduit(state.sink);
        this.channel.getSourceChannel().setConduit(state.source);
    }

    protected static StreamSinkConduit sink(ConduitState state) {
        return state.sink;
    }

    protected static StreamSourceConduit source(ConduitState state) {
        return state.source;
    }

    @Override
    public void addCloseListener(ServerConnection.CloseListener listener) {
        this.closeListeners.add(listener);
    }

    @Override
    protected ConduitStreamSinkChannel getSinkChannel() {
        return this.channel.getSinkChannel();
    }

    @Override
    protected ConduitStreamSourceChannel getSourceChannel() {
        return this.channel.getSourceChannel();
    }

    @Override
    protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    private class CloseSetter
    implements ChannelListener.Setter<ServerConnection>,
    ChannelListener<StreamConnection> {
        private ChannelListener<? super ServerConnection> listener;

        private CloseSetter() {
        }

        public void set(ChannelListener<? super ServerConnection> listener) {
            this.listener = listener;
        }

        public void handleEvent(StreamConnection channel) {
            for (ServerConnection.CloseListener l : AbstractServerConnection.this.closeListeners) {
                try {
                    l.closed(AbstractServerConnection.this);
                }
                catch (Throwable e) {
                    UndertowLogger.REQUEST_LOGGER.exceptionInvokingCloseListener(l, e);
                }
            }
            ChannelListeners.invokeChannelListener((Channel)((Object)AbstractServerConnection.this), this.listener);
        }
    }

    public static class ConduitState {
        final StreamSinkConduit sink;
        final StreamSourceConduit source;

        private ConduitState(StreamSinkConduit sink, StreamSourceConduit source) {
            this.sink = sink;
            this.source = source;
        }
    }
}

