/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AbstractAjpParseState;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

public abstract class AbstractAjpParser {
    public static final int STRING_LENGTH_MASK = Integer.MIN_VALUE;

    protected IntegerHolder parse16BitInteger(ByteBuffer buf, AbstractAjpParseState state) {
        if (!buf.hasRemaining()) {
            return new IntegerHolder(-1, false);
        }
        int number = state.currentIntegerPart;
        if (number == -1) {
            number = buf.get() & 0xFF;
        }
        if (buf.hasRemaining()) {
            byte b = buf.get();
            int result = ((0xFF & number) << 8) + (b & 0xFF);
            state.currentIntegerPart = -1;
            return new IntegerHolder(result, true);
        }
        state.currentIntegerPart = number;
        return new IntegerHolder(-1, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected StringHolder parseString(ByteBuffer buf, AbstractAjpParseState state, boolean header) {
        int number;
        if (!buf.hasRemaining()) {
            return new StringHolder(null, false);
        }
        int stringLength = state.stringLength;
        if (stringLength == -1) {
            number = buf.get() & 0xFF;
            if (!buf.hasRemaining()) {
                state.stringLength = number | Integer.MIN_VALUE;
                return new StringHolder(null, false);
            }
            byte b = buf.get();
            stringLength = ((0xFF & number) << 8) + (b & 0xFF);
        } else if ((stringLength & Integer.MIN_VALUE) != 0) {
            number = stringLength & Integer.MAX_VALUE;
            stringLength = ((0xFF & number) << 8) + (buf.get() & 0xFF);
        }
        if (header && (stringLength & 0xFF00) != 0) {
            state.stringLength = -1;
            return new StringHolder(this.headers(stringLength & 0xFF));
        }
        if (stringLength == 65535) {
            state.stringLength = -1;
            return new StringHolder(null, true);
        }
        StringBuilder builder = state.currentString;
        if (builder == null) {
            state.currentString = builder = new StringBuilder();
        }
        for (int length = builder.length(); length < stringLength; ++length) {
            if (!buf.hasRemaining()) {
                state.stringLength = stringLength;
                return new StringHolder(null, false);
            }
            builder.append((char)buf.get());
        }
        if (buf.hasRemaining()) {
            buf.get();
            state.currentString = null;
            state.stringLength = -1;
            return new StringHolder(builder.toString(), true);
        }
        return new StringHolder(null, false);
    }

    protected abstract HttpString headers(int var1);

    protected static class StringHolder {
        public final String value;
        public final HttpString header;
        public final boolean readComplete;

        private StringHolder(String value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
            this.header = null;
        }

        private StringHolder(HttpString value) {
            this.value = null;
            this.readComplete = true;
            this.header = value;
        }
    }

    protected static class IntegerHolder {
        public final int value;
        public final boolean readComplete;

        private IntegerHolder(int value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
        }
    }
}

