/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AbstractAjpParseState;
import io.undertow.server.BasicSSLSessionInfo;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.Map;
import javax.security.cert.CertificateException;

class AjpRequestParseState
extends AbstractAjpParseState {
    public static final int BEGIN = 0;
    public static final int READING_MAGIC_NUMBER = 1;
    public static final int READING_DATA_SIZE = 2;
    public static final int READING_PREFIX_CODE = 3;
    public static final int READING_METHOD = 4;
    public static final int READING_PROTOCOL = 5;
    public static final int READING_REQUEST_URI = 6;
    public static final int READING_REMOTE_ADDR = 7;
    public static final int READING_REMOTE_HOST = 8;
    public static final int READING_SERVER_NAME = 9;
    public static final int READING_SERVER_PORT = 10;
    public static final int READING_IS_SSL = 11;
    public static final int READING_NUM_HEADERS = 12;
    public static final int READING_HEADERS = 13;
    public static final int READING_ATTRIBUTES = 14;
    public static final int DONE = 15;
    int state;
    byte prefix;
    int dataSize;
    int numHeaders = 0;
    HttpString currentHeader;
    String currentAttribute;
    Map<String, String> attributes = new HashMap<String, String>();

    AjpRequestParseState() {
    }

    public boolean isComplete() {
        return this.state == 15;
    }

    BasicSSLSessionInfo createSslSessionInfo() {
        String sessionId = this.attributes.get("ssl_session");
        String cypher = this.attributes.get("ssl_cipher");
        String cert = this.attributes.get("ssl_cert");
        if (sessionId == null || cypher == null) {
            return null;
        }
        try {
            return new BasicSSLSessionInfo(sessionId, cypher, cert);
        }
        catch (java.security.cert.CertificateException e) {
            return null;
        }
        catch (CertificateException e) {
            return null;
        }
    }
}

