/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class GatedStreamSinkChannel
implements StreamSinkChannel {
    private final StreamSinkChannel delegate;
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private int state;
    private static final int FLAG_GATE_OPEN = 1;
    private static final int FLAG_WRITES_RESUMED = 2;
    private static final int FLAG_CLOSE_REQUESTED = 4;
    private static final int FLAG_CLOSED = 8;

    public GatedStreamSinkChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    public void openGate() throws IOException {
        int val = this.state;
        if (Bits.allAreSet((int)val, (int)1)) {
            return;
        }
        this.state |= 1;
        if (Bits.allAreSet((int)val, (int)8)) {
            this.delegate.close();
        } else {
            if (Bits.allAreSet((int)val, (int)4)) {
                this.delegate.shutdownWrites();
            }
            if (Bits.allAreSet((int)val, (int)2)) {
                this.delegate.wakeupWrites();
            }
        }
    }

    public boolean isGateOpen() {
        return Bits.allAreSet((int)this.state, (int)1);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.handleGate()) {
            return 0;
        }
        return this.delegate.write(src);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.write(srcs, offset, length);
    }

    private boolean handleGate() throws ClosedChannelException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        return Bits.anyAreClear((int)val, (int)1);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.transferFrom(src, position, count);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreClear((int)this.state, (int)1)) {
            return false;
        }
        if (Bits.anyAreSet((int)this.state, (int)8)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            boolean result = this.delegate.flush();
            if (result) {
                this.state |= 8;
            }
            return result;
        }
        return this.delegate.flush();
    }

    public void suspendWrites() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.suspendWrites();
        } else {
            this.state &= 0xFFFFFFFD;
        }
    }

    public void resumeWrites() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.resumeWrites();
        } else {
            this.state |= 2;
        }
    }

    public boolean isWriteResumed() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return this.delegate.isWriteResumed();
        }
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public void wakeupWrites() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.wakeupWrites();
        } else {
            this.state |= 2;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelListeners.invokeChannelListener((Channel)((Object)GatedStreamSinkChannel.this), (ChannelListener)GatedStreamSinkChannel.this.writeSetter.get());
                }
            });
        }
    }

    public void shutdownWrites() throws IOException {
        this.state |= 4;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.shutdownWrites();
        }
    }

    public void close() throws IOException {
        if (Bits.allAreSet((int)this.state, (int)8)) {
            return;
        }
        this.state |= 8;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.close();
        }
    }

    public void awaitWritable() throws IOException {
        if (Bits.allAreClear((int)this.state, (int)1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.allAreClear((int)this.state, (int)1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)8);
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public StreamSinkChannel getChannel() {
        return Bits.allAreSet((int)this.state, (int)1) ? this.delegate : this;
    }
}

