/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.UndertowMessages;
import io.undertow.conduits.AbstractFramedStreamSinkConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AjpServerRequestConduit;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

final class AjpServerResponseConduit
extends AbstractFramedStreamSinkConduit {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.channel.ajp.response");
    private static final int MAX_DATA_SIZE = 8184;
    private static final Map<HttpString, Integer> HEADER_MAP;
    private static final int FLAG_START = 1;
    private static final int FLAG_WRITE_RESUMED = 4;
    private static final int FLAG_WRITE_READ_BODY_CHUNK_FROM_LISTENER = 8;
    private static final int FLAG_WRITE_SHUTDOWN = 16;
    private static final ByteBuffer CLOSE_FRAME_PERSISTENT;
    private static final ByteBuffer CLOSE_FRAME_NON_PERSISTENT;
    private final Pool<ByteBuffer> pool;
    private int state = 1;
    private final HttpServerExchange exchange;
    private final ConduitListener<? super AjpServerResponseConduit> finishListener;
    private final boolean headRequest;

    AjpServerResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, HttpServerExchange exchange, ConduitListener<? super AjpServerResponseConduit> finishListener, boolean headRequest) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
        this.finishListener = finishListener;
        this.headRequest = headRequest;
        this.state = 1;
    }

    private static void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    private static void putString(ByteBuffer buf, String value) {
        int length = value.length();
        AjpServerResponseConduit.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    private void putHttpString(ByteBuffer buf, HttpString value) {
        int length = value.length();
        AjpServerResponseConduit.putInt(buf, length);
        value.appendTo(buf);
        buf.put((byte)0);
    }

    private void processAJPHeader() {
        int oldState = this.state;
        if (Bits.anyAreSet((int)oldState, (int)1)) {
            Pooled[] byteBuffers = null;
            Connectors.flattenCookies(this.exchange);
            Pooled pooled = this.pool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.put((byte)65);
            buffer.put((byte)66);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)4);
            AjpServerResponseConduit.putInt(buffer, this.exchange.getResponseCode());
            AjpServerResponseConduit.putString(buffer, StatusCodes.getReason(this.exchange.getResponseCode()));
            int headers = 0;
            HeaderMap responseHeaders = this.exchange.getResponseHeaders();
            for (HttpString name : responseHeaders.getHeaderNames()) {
                headers += responseHeaders.get(name).size();
            }
            AjpServerResponseConduit.putInt(buffer, headers);
            for (HttpString header : responseHeaders.getHeaderNames()) {
                for (String headerValue : responseHeaders.get(header)) {
                    Integer headerCode;
                    if (buffer.remaining() < header.length() + headerValue.length() + 6) {
                        buffer.flip();
                        if (byteBuffers == null) {
                            byteBuffers = new Pooled[2];
                            byteBuffers[0] = pooled;
                        } else {
                            Pooled[] old = byteBuffers;
                            byteBuffers = new Pooled[old.length + 1];
                            System.arraycopy(old, 0, byteBuffers, 0, old.length);
                        }
                        byteBuffers[byteBuffers.length - 1] = pooled = this.pool.allocate();
                        buffer = (ByteBuffer)pooled.getResource();
                    }
                    if ((headerCode = HEADER_MAP.get(header)) != null) {
                        AjpServerResponseConduit.putInt(buffer, headerCode);
                    } else {
                        this.putHttpString(buffer, header);
                    }
                    AjpServerResponseConduit.putString(buffer, headerValue);
                }
            }
            if (byteBuffers == null) {
                int dataLength = buffer.position() - 4;
                buffer.put(2, (byte)(dataLength >> 8 & 0xFF));
                buffer.put(3, (byte)(dataLength & 0xFF));
                buffer.flip();
                this.queueFrame(new AbstractFramedStreamSinkConduit.PooledBufferFrameCallback((Pooled<ByteBuffer>)pooled), buffer);
            } else {
                Buffer[] bufs = new ByteBuffer[byteBuffers.length];
                for (int i = 0; i < bufs.length; ++i) {
                    bufs[i] = (ByteBuffer)byteBuffers[i].getResource();
                }
                int dataLength = (int)(Buffers.remaining((Buffer[])bufs) - 4L);
                ((ByteBuffer)bufs[0]).put(2, (byte)(dataLength >> 8 & 0xFF));
                ((ByteBuffer)bufs[0]).put(3, (byte)(dataLength & 0xFF));
                buffer.flip();
                this.queueFrame(new AbstractFramedStreamSinkConduit.PooledBuffersFrameCallback(byteBuffers), (ByteBuffer[])bufs);
            }
            this.state &= 0xFFFFFFFE;
        }
    }

    @Override
    protected void queueCloseFrames() {
        this.processAJPHeader();
        ByteBuffer buffer = this.exchange.isPersistent() ? CLOSE_FRAME_PERSISTENT.duplicate() : CLOSE_FRAME_NON_PERSISTENT.duplicate();
        this.queueFrame(null, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.queuedDataLength() > 0L && !this.flush()) {
            return 0;
        }
        this.processAJPHeader();
        if (this.headRequest) {
            int remaining = src.remaining();
            src.position(src.position() + remaining);
            return remaining;
        }
        int limit = src.limit();
        try {
            if (src.remaining() > 8184) {
                src.limit(src.position() + 8184);
            }
            int writeSize = src.remaining();
            ByteBuffer[] buffers = this.createHeader(src);
            int toWrite = 0;
            for (ByteBuffer buffer : buffers) {
                toWrite += buffer.remaining();
            }
            int originalPayloadSize = writeSize;
            long r = 0L;
            do {
                r = super.write(buffers, 0, buffers.length);
                toWrite = (int)((long)toWrite - r);
                if (r == -1L) {
                    throw new ClosedChannelException();
                }
                if (r != 0L) continue;
                Pooled newPooledBuffer = this.pool.allocate();
                while (src.hasRemaining()) {
                    ((ByteBuffer)newPooledBuffer.getResource()).put(src);
                }
                ((ByteBuffer)newPooledBuffer.getResource()).flip();
                ByteBuffer[] savedBuffers = new ByteBuffer[]{buffers[0], (ByteBuffer)newPooledBuffer.getResource(), buffers[2]};
                this.queueFrame(new AbstractFramedStreamSinkConduit.PooledBufferFrameCallback((Pooled<ByteBuffer>)newPooledBuffer), savedBuffers);
                int n = originalPayloadSize;
                return n;
            } while (toWrite > 0);
            int n = originalPayloadSize;
            return n;
        }
        finally {
            src.limit(limit);
        }
    }

    private ByteBuffer[] createHeader(ByteBuffer src) {
        int remaining = src.remaining();
        int chunkSize = remaining + 4;
        byte[] header = new byte[]{65, 66, (byte)(chunkSize >> 8 & 0xFF), (byte)(chunkSize & 0xFF), 3, (byte)(remaining >> 8 & 0xFF), (byte)(remaining & 0xFF)};
        byte[] footer = new byte[]{0};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(header), src, ByteBuffer.wrap(footer)};
        return buffers;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            while (srcs[i].hasRemaining()) {
                int written = this.write(srcs[i]);
                if (written == 0) {
                    return total;
                }
                total += (long)written;
            }
        }
        return total;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    @Override
    protected void finished() {
        if (this.finishListener != null) {
            this.finishListener.handleEvent(this);
        }
    }

    public void setWriteReadyHandler(WriteReadyHandler handler) {
        ((StreamSinkConduit)this.next).setWriteReadyHandler((WriteReadyHandler)new AjpServerWriteReadyHandler(handler));
    }

    public void suspendWrites() {
        log.trace((Object)"suspend");
        this.state &= 0xFFFFFFFB;
        if (Bits.allAreClear((int)this.state, (int)8)) {
            ((StreamSinkConduit)this.next).suspendWrites();
        }
    }

    public void resumeWrites() {
        log.trace((Object)"resume");
        this.state |= 4;
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    public boolean isWriteResumed() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public void wakeupWrites() {
        log.trace((Object)"wakeup");
        this.state |= 4;
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    @Override
    protected void doTerminateWrites() throws IOException {
        if (!this.exchange.isPersistent()) {
            ((StreamSinkConduit)this.next).terminateWrites();
        }
        this.state |= 0x10;
    }

    public boolean isWriteShutdown() {
        return super.isWriteShutdown() || Bits.anyAreSet((int)this.state, (int)16);
    }

    boolean doGetRequestBodyChunk(ByteBuffer buffer, final AjpServerRequestConduit requestChannel) throws IOException {
        if (this.isWriteShutdown()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        super.write(buffer);
        if (buffer.hasRemaining()) {
            this.state |= 8;
            this.queueFrame(new AbstractFramedStreamSinkConduit.FrameCallBack(){

                @Override
                public void done() {
                    AjpServerResponseConduit.this.state &= -9;
                    if (Bits.allAreClear((int)AjpServerResponseConduit.this.state, (int)4)) {
                        ((StreamSinkConduit)AjpServerResponseConduit.this.next).suspendWrites();
                    }
                }

                @Override
                public void failed(IOException e) {
                    requestChannel.setReadBodyChunkError(e);
                }
            }, buffer);
            ((StreamSinkConduit)this.next).resumeWrites();
            return false;
        }
        return true;
    }

    static {
        HashMap<HttpString, Integer> headers = new HashMap<HttpString, Integer>();
        headers.put(Headers.CONTENT_TYPE, 40961);
        headers.put(Headers.CONTENT_LANGUAGE, 40962);
        headers.put(Headers.CONTENT_LENGTH, 40963);
        headers.put(Headers.DATE, 40964);
        headers.put(Headers.LAST_MODIFIED, 40965);
        headers.put(Headers.LOCATION, 40966);
        headers.put(Headers.SET_COOKIE, 40967);
        headers.put(Headers.SET_COOKIE2, 40968);
        headers.put(Headers.SERVLET_ENGINE, 40969);
        headers.put(Headers.STATUS, 40970);
        headers.put(Headers.WWW_AUTHENTICATE, 40971);
        HEADER_MAP = Collections.unmodifiableMap(headers);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[6]);
        buffer.put((byte)65);
        buffer.put((byte)66);
        buffer.put((byte)0);
        buffer.put((byte)2);
        buffer.put((byte)5);
        buffer.put((byte)1);
        buffer.flip();
        CLOSE_FRAME_PERSISTENT = buffer;
        buffer = ByteBuffer.wrap(new byte[6]);
        buffer.put(CLOSE_FRAME_PERSISTENT.duplicate());
        buffer.put(5, (byte)0);
        buffer.flip();
        CLOSE_FRAME_NON_PERSISTENT = buffer;
    }

    private final class AjpServerWriteReadyHandler
    implements WriteReadyHandler {
        private final WriteReadyHandler delegate;

        private AjpServerWriteReadyHandler(WriteReadyHandler delegate) {
            this.delegate = delegate;
        }

        public void writeReady() {
            if (Bits.anyAreSet((int)AjpServerResponseConduit.this.state, (int)8)) {
                try {
                    AjpServerResponseConduit.this.flush();
                }
                catch (IOException e) {
                    log.debug((Object)"Error flushing when doing async READ_BODY_CHUNK flush", (Throwable)e);
                }
            }
            if (Bits.anyAreSet((int)AjpServerResponseConduit.this.state, (int)4)) {
                this.delegate.writeReady();
            }
        }

        public void forceTermination() {
            this.delegate.forceTermination();
        }

        public void terminated() {
            this.delegate.terminated();
        }
    }
}

