/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.attribute.SubstituteEmptyWrapper;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;

public class AccessLogHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final ExchangeAttribute tokens;
    private final ExchangeCompletionListener exchangeCompletionListener = new AccessLogCompletionListener();

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ClassLoader classLoader) {
        this.next = next;
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = ExchangeAttributes.parser(classLoader, new SubstituteEmptyWrapper("-")).parse(this.formatString);
    }

    private static String handleCommonNames(String formatString) {
        if (formatString.equals("common")) {
            return "%h %l %u %t \"%r\" %s %b";
        }
        if (formatString.equals("combined")) {
            return "%h %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
        }
        return formatString;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + '\'' + '}';
    }

    private class AccessLogCompletionListener
    implements ExchangeCompletionListener {
        private AccessLogCompletionListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                AccessLogHandler.this.accessLogReceiver.logMessage(AccessLogHandler.this.tokens.readAttribute(exchange));
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

