/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public abstract class StreamSourceFrameChannel
extends AbstractFramedStreamSourceChannel<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    protected final WebSocketFrameType type;
    private boolean finalFragment;
    private final int rsv;
    private final long payloadSize;

    protected StreamSourceFrameChannel(WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize, Pooled<ByteBuffer> pooled, long frameLength) {
        this(wsChannel, type, payloadSize, 0, true, pooled, frameLength);
    }

    protected StreamSourceFrameChannel(WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize, int rsv, boolean finalFragment, Pooled<ByteBuffer> pooled, long frameLength) {
        super(wsChannel, pooled, frameLength);
        this.type = type;
        this.finalFragment = finalFragment;
        this.rsv = rsv;
        this.payloadSize = payloadSize;
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    public int getRsv() {
        return this.rsv;
    }

    int getWebSocketFrameCount() {
        return this.getReadFrameCount();
    }

    public void discard() throws IOException {
        if (this.isOpen()) {
            ChannelListener drainListener = ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    IoUtils.safeClose((Closeable)((Object)StreamSourceFrameChannel.this));
                }
            }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                public void handleException(StreamSourceChannel channel, IOException exception) {
                    StreamSourceFrameChannel.this.getFramedChannel().markReadsBroken(exception);
                }
            });
            this.getReadSetter().set(drainListener);
            this.resumeReads();
        } else {
            this.close();
        }
    }

    protected WebSocketChannel getFramedChannel() {
        return (WebSocketChannel)super.getFramedChannel();
    }

    public WebSocketChannel getWebSocketChannel() {
        return this.getFramedChannel();
    }

    public void finalFrame() {
        this.lastFrame();
        this.finalFragment = true;
    }
}

