/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class PeerNameResolvingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ResolveType resolveType;

    public PeerNameResolvingHandler(HttpHandler next) {
        this.next = next;
        this.resolveType = ResolveType.FORWARD_AND_REVERSE;
    }

    public PeerNameResolvingHandler(HttpHandler next, ResolveType resolveType) {
        this.next = next;
        this.resolveType = resolveType;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        block9: {
            final InetSocketAddress address = exchange.getSourceAddress();
            if (address != null) {
                if ((this.resolveType == ResolveType.FORWARD || this.resolveType == ResolveType.FORWARD_AND_REVERSE) && address.isUnresolved()) {
                    try {
                        if (System.getSecurityManager() == null) {
                            InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                            exchange.setSourceAddress(resolvedAddress);
                            break block9;
                        }
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws UnknownHostException {
                                InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                                exchange.setSourceAddress(resolvedAddress);
                                return null;
                            }
                        });
                    }
                    catch (UnknownHostException e) {
                        UndertowLogger.REQUEST_LOGGER.debugf(e, "Could not resolve hostname %s", address.getHostString());
                    }
                } else if (this.resolveType == ResolveType.REVERSE || this.resolveType == ResolveType.FORWARD_AND_REVERSE) {
                    if (System.getSecurityManager() == null) {
                        address.getHostName();
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                address.getHostName();
                                return null;
                            }
                        });
                    }
                    exchange.setSourceAddress(address);
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    public static enum ResolveType {
        FORWARD,
        REVERSE,
        FORWARD_AND_REVERSE;

    }
}

