/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyHeaderBlockParser;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import org.xnio.Pool;

class SpdySynStreamParser
extends SpdyHeaderBlockParser {
    private static final int STREAM_ID_MASK = -129;
    private int associatedToStreamId = -1;
    private int priority = -1;

    public SpdySynStreamParser(Pool<ByteBuffer> bufferPool, SpdyChannel channel, int frameLength, Inflater inflater) {
        super(bufferPool, channel, frameLength, inflater);
    }

    @Override
    protected boolean handleBeforeHeader(ByteBuffer resource) {
        if (this.streamId == -1) {
            if (resource.remaining() < 4) {
                return false;
            }
            this.streamId = (resource.get() & 0xFFFFFF7F & 0xFF) << 24;
            this.streamId += (resource.get() & 0xFF) << 16;
            this.streamId += (resource.get() & 0xFF) << 8;
            this.streamId += resource.get() & 0xFF;
        }
        if (this.associatedToStreamId == -1) {
            if (resource.remaining() < 4) {
                return false;
            }
            this.associatedToStreamId = (resource.get() & 0xFFFFFF7F & 0xFF) << 24;
            this.associatedToStreamId += (resource.get() & 0xFF) << 16;
            this.associatedToStreamId += (resource.get() & 0xFF) << 8;
            this.associatedToStreamId += resource.get() & 0xFF;
        }
        if (this.priority == -1) {
            if (resource.remaining() < 2) {
                return false;
            }
            this.priority = resource.get() >> 5 & 0xFF;
            resource.get();
        }
        return true;
    }

    public int getAssociatedToStreamId() {
        return this.associatedToStreamId;
    }

    public int getPriority() {
        return this.priority;
    }
}

