/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class FlexBase64 {
    private static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;
    private static final Constructor<String> STRING_CONSTRUCTOR;

    public static Encoder createEncoder(boolean wrap) {
        return new Encoder(wrap);
    }

    public static Decoder createDecoder() {
        return new Decoder();
    }

    public static String encodeString(byte[] source, boolean wrap) {
        return Encoder.encodeString(source, 0, source.length, wrap);
    }

    public static String encodeString(byte[] source, int pos, int limit, boolean wrap) {
        return Encoder.encodeString(source, pos, limit, wrap);
    }

    public static String encodeString(ByteBuffer source, boolean wrap) {
        return Encoder.encodeString(source, wrap);
    }

    public static byte[] encodeBytes(byte[] source, int pos, int limit, boolean wrap) {
        return Encoder.encodeBytes(source, pos, limit, wrap);
    }

    public static ByteBuffer decode(String source) throws IOException {
        return Decoder.decode(source);
    }

    public static ByteBuffer decode(ByteBuffer source) throws IOException {
        return Decoder.decode(source);
    }

    public static ByteBuffer decode(byte[] source, int off, int limit) throws IOException {
        return Decoder.decode(source, off, limit);
    }

    public static EncoderInputStream createEncoderInputStream(InputStream source, int bufferSize, boolean wrap) {
        return new EncoderInputStream(source, bufferSize, wrap);
    }

    public static EncoderInputStream createEncoderInputStream(InputStream source) {
        return new EncoderInputStream(source);
    }

    public static DecoderInputStream createDecoderInputStream(InputStream source, int bufferSize) {
        return new DecoderInputStream(source, bufferSize);
    }

    public static DecoderInputStream createDecoderInputStream(InputStream source) {
        return new DecoderInputStream(source);
    }

    public static EncoderOutputStream createEncoderOutputStream(OutputStream target, int bufferSize, boolean wrap) {
        return new EncoderOutputStream(target, bufferSize, wrap);
    }

    public static EncoderOutputStream createEncoderOutputStream(OutputStream output) {
        return new EncoderOutputStream(output);
    }

    public static DecoderOutputStream createDecoderOutputStream(OutputStream output, int bufferSize) {
        return new DecoderOutputStream(output, bufferSize);
    }

    public static DecoderOutputStream createDecoderOutputStream(OutputStream output) {
        return new DecoderOutputStream(output);
    }

    static {
        DECODING_TABLE = new byte[80];
        try {
            ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < ENCODING_TABLE.length; ++i) {
            int v = (ENCODING_TABLE[i] & 0xFF) - 43;
            FlexBase64.DECODING_TABLE[v] = (byte)(i + 1);
        }
        Constructor c = null;
        try {
            PrivilegedExceptionAction<Constructor<String>> runnable = new PrivilegedExceptionAction<Constructor<String>>(){

                @Override
                public Constructor<String> run() throws Exception {
                    Constructor<String> c = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                    c.setAccessible(true);
                    return c;
                }
            };
            c = System.getSecurityManager() != null ? AccessController.doPrivileged(runnable) : (Constructor)runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        STRING_CONSTRUCTOR = c;
    }

    public static class DecoderOutputStream
    extends OutputStream {
        private final OutputStream output;
        private final byte[] buffer;
        private final Decoder decoder;
        private int pos = 0;
        private byte[] one;

        private DecoderOutputStream(OutputStream output) {
            this(output, 8192);
        }

        private DecoderOutputStream(OutputStream output, int bufferSize) {
            this.output = output;
            this.buffer = new byte[bufferSize];
            this.decoder = FlexBase64.createDecoder();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] buffer = this.buffer;
            Decoder decoder = this.decoder;
            int pos = this.pos;
            int limit = off + len;
            int ipos = off;
            while (ipos < limit) {
                pos = decoder.decode(b, ipos, limit, buffer, pos, buffer.length);
                int last = decoder.getLastInputPosition();
                if (last == ipos || pos >= buffer.length) {
                    this.output.write(buffer, 0, pos);
                    pos = 0;
                }
                ipos = last;
            }
            this.pos = pos;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] one = this.one;
            if (one == null) {
                this.one = one = new byte[1];
            }
            one[0] = (byte)b;
            this.write(one, 0, 1);
        }

        @Override
        public void flush() throws IOException {
            OutputStream output = this.output;
            output.write(this.buffer, 0, this.pos);
            output.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.output.close();
        }
    }

    public static class EncoderOutputStream
    extends OutputStream {
        private final OutputStream output;
        private final byte[] buffer;
        private final Encoder encoder;
        private int pos = 0;
        private byte[] one;

        private EncoderOutputStream(OutputStream output) {
            this(output, 8192, true);
        }

        private EncoderOutputStream(OutputStream output, int bufferSize, boolean wrap) {
            this.output = output;
            this.buffer = new byte[bufferSize];
            this.encoder = FlexBase64.createEncoder(wrap);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] buffer = this.buffer;
            Encoder encoder = this.encoder;
            int pos = this.pos;
            int limit = off + len;
            int ipos = off;
            while (ipos < limit) {
                pos = encoder.encode(b, ipos, limit, buffer, pos, buffer.length);
                int last = encoder.getLastInputPosition();
                if (last == ipos || pos >= buffer.length) {
                    this.output.write(buffer, 0, pos);
                    pos = 0;
                }
                ipos = last;
            }
            this.pos = pos;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] one = this.one;
            if (one == null) {
                this.one = one = new byte[1];
            }
            one[0] = (byte)b;
            this.write(one, 0, 1);
        }

        @Override
        public void flush() throws IOException {
            OutputStream output = this.output;
            output.write(this.buffer, 0, this.pos);
            output.flush();
        }

        public void complete() throws IOException {
            OutputStream output = this.output;
            byte[] buffer = this.buffer;
            int pos = this.pos;
            boolean completed = false;
            if (buffer.length - pos >= (this.encoder.wrap ? 2 : 4)) {
                this.pos = this.encoder.complete(buffer, pos);
                completed = true;
            }
            this.flush();
            if (!completed) {
                int len = this.encoder.complete(buffer, 0);
                output.write(buffer, 0, len);
                output.flush();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.complete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.output.close();
        }
    }

    public static class EncoderInputStream
    extends InputStream {
        private final InputStream input;
        private final byte[] buffer;
        private final byte[] overflow = new byte[6];
        private int overflowPos;
        private int overflowLimit;
        private final Encoder encoder;
        private int pos = 0;
        private int limit = 0;
        private byte[] one;
        private boolean complete;

        private EncoderInputStream(InputStream input) {
            this(input, 8192, true);
        }

        private EncoderInputStream(InputStream input, int bufferSize, boolean wrap) {
            this.input = input;
            this.buffer = new byte[bufferSize];
            this.encoder = new Encoder(wrap);
        }

        private int fill() throws IOException {
            byte[] buffer = this.buffer;
            int read = this.input.read(buffer, 0, buffer.length);
            this.pos = 0;
            this.limit = read;
            return read;
        }

        @Override
        public int read() throws IOException {
            int read;
            byte[] one = this.one;
            if (one == null) {
                one = this.one = new byte[1];
            }
            return (read = this.read(one, 0, 1)) > 0 ? one[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            byte[] buffer = this.buffer;
            byte[] overflow = this.overflow;
            int overflowPos = this.overflowPos;
            int overflowLimit = this.overflowLimit;
            boolean complete = this.complete;
            boolean wrap = this.encoder.wrap;
            int copy = 0;
            if (overflowPos < overflowLimit) {
                copy = this.copyOverflow(b, off, len, overflow, overflowPos, overflowLimit);
                if (len <= copy || complete) {
                    return copy;
                }
                len -= copy;
                off += copy;
            } else if (complete) {
                return -1;
            }
            do {
                byte[] source = buffer;
                int pos = this.pos;
                int limit = this.limit;
                boolean setPos = true;
                if (pos >= limit) {
                    if (len > source.length) {
                        int adjust = len / 4 * 3 - 3;
                        if (wrap) {
                            adjust -= adjust / 76 * 2 + 2;
                        }
                        source = new byte[adjust];
                        limit = this.input.read(source, 0, adjust);
                        pos = 0;
                        setPos = false;
                    } else {
                        limit = this.fill();
                        pos = 0;
                    }
                    if (limit <= 0) {
                        int ret;
                        this.complete = true;
                        if (len < (wrap ? 4 : 2)) {
                            this.overflowLimit = overflowLimit = this.encoder.complete(overflow, 0);
                            ret = this.copyOverflow(b, off, len, overflow, 0, overflowLimit) + copy;
                            return ret == 0 ? -1 : ret;
                        }
                        ret = this.encoder.complete(b, off) - off + copy;
                        return ret == 0 ? -1 : ret;
                    }
                }
                if (len < (wrap ? 6 : 4)) {
                    this.overflowLimit = overflowLimit = this.encoder.encode(source, pos, limit, overflow, 0, overflow.length);
                    this.pos = this.encoder.getLastInputPosition();
                    return this.copyOverflow(b, off, len, overflow, 0, overflowLimit) + copy;
                }
                read = this.encoder.encode(source, pos, limit, b, off, off + len) - off;
                if (!setPos) continue;
                this.pos = this.encoder.getLastInputPosition();
            } while (read <= 0);
            return read + copy;
        }

        private int copyOverflow(byte[] b, int off, int len, byte[] overflow, int pos, int limit) {
            len = (limit -= pos) <= len ? limit : len;
            System.arraycopy(overflow, pos, b, off, len);
            this.overflowPos = pos + len;
            return len;
        }
    }

    public static class DecoderInputStream
    extends InputStream {
        private final InputStream input;
        private final byte[] buffer;
        private final Decoder decoder = FlexBase64.createDecoder();
        private int pos = 0;
        private int limit = 0;
        private byte[] one;

        private DecoderInputStream(InputStream input) {
            this(input, 8192);
        }

        private DecoderInputStream(InputStream input, int bufferSize) {
            this.input = input;
            this.buffer = new byte[bufferSize];
        }

        private int fill() throws IOException {
            byte[] buffer = this.buffer;
            int read = this.input.read(buffer, 0, buffer.length);
            this.pos = 0;
            this.limit = read;
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            do {
                int requested;
                byte[] source = this.buffer;
                int pos = this.pos;
                int limit = this.limit;
                boolean setPos = true;
                if (pos >= limit) {
                    if (len > source.length) {
                        source = new byte[len];
                        limit = this.input.read(source, 0, len);
                        pos = 0;
                        setPos = false;
                    } else {
                        limit = this.fill();
                        pos = 0;
                    }
                    if (limit == -1) {
                        return -1;
                    }
                }
                limit = limit > (requested = len + pos) ? requested : limit;
                read = this.decoder.decode(source, pos, limit, b, off, off + len) - off;
                if (!setPos) continue;
                this.pos = this.decoder.getLastInputPosition();
            } while (read <= 0);
            return read;
        }

        @Override
        public int read() throws IOException {
            int read;
            byte[] one = this.one;
            if (one == null) {
                one = this.one = new byte[1];
            }
            return (read = this.read(one, 0, 1)) > 0 ? one[0] & 0xFF : -1;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    public static final class Decoder {
        private int state;
        private int last;
        private int lastPos;
        private static final int SKIP = 64768;
        private static final int MARK = 65024;
        private static final int DONE = 65280;
        private static final int ERROR = 983040;

        private Decoder() {
        }

        private static int nextByte(ByteBuffer buffer, int state, int last, boolean ignoreErrors) throws IOException {
            return Decoder.nextByte(buffer.get() & 0xFF, state, last, ignoreErrors);
        }

        private static int nextByte(Object source, int pos, int state, int last, boolean ignoreErrors) throws IOException {
            int c;
            if (source instanceof byte[]) {
                c = ((byte[])source)[pos] & 0xFF;
            } else if (source instanceof String) {
                c = ((String)source).charAt(pos) & 0xFF;
            } else {
                throw new IllegalArgumentException();
            }
            return Decoder.nextByte(c, state, last, ignoreErrors);
        }

        private static int nextByte(int c, int state, int last, boolean ignoreErrors) throws IOException {
            if (last == 65024) {
                if (c != 61) {
                    throw new IOException("Expected padding character");
                }
                return 65280;
            }
            if (c == 61) {
                if (state == 2) {
                    return 65024;
                }
                if (state == 3) {
                    return 65280;
                }
                throw new IOException("Unexpected padding character");
            }
            if (c == 32 || c == 9 || c == 13 || c == 10) {
                return 64768;
            }
            if (c < 43 || c > 122) {
                if (ignoreErrors) {
                    return 983040;
                }
                throw new IOException("Invalid base64 character encountered: " + c);
            }
            int b = (DECODING_TABLE[c - 43] & 0xFF) - 1;
            if (b < 0) {
                if (ignoreErrors) {
                    return 983040;
                }
                throw new IOException("Invalid base64 character encountered: " + c);
            }
            return b;
        }

        public void decode(ByteBuffer source, ByteBuffer target) throws IOException {
            if (target == null) {
                throw new IllegalStateException();
            }
            int last = this.last;
            int state = this.state;
            int remaining = source.remaining();
            int targetRemaining = target.remaining();
            int b = 0;
            while (remaining-- > 0 && targetRemaining > 0) {
                b = Decoder.nextByte(source, state, last, false);
                if (b == 65024) {
                    last = 65024;
                    if (--remaining <= 0) break;
                    b = Decoder.nextByte(source, state, last, false);
                }
                if (b == 65280) {
                    state = 0;
                    last = 0;
                    break;
                }
                if (b == 64768) continue;
                if (state == 0) {
                    last = b << 2;
                    ++state;
                    if (remaining-- <= 0) break;
                    b = Decoder.nextByte(source, state, last, false);
                    if ((b & 0xF000) != 0) {
                        source.position(source.position() - 1);
                        continue;
                    }
                }
                if (state == 1) {
                    target.put((byte)(last | b >>> 4));
                    last = (b & 0xF) << 4;
                    ++state;
                    if (remaining-- <= 0 || --targetRemaining <= 0) break;
                    b = Decoder.nextByte(source, state, last, false);
                    if ((b & 0xF000) != 0) {
                        source.position(source.position() - 1);
                        continue;
                    }
                }
                if (state == 2) {
                    target.put((byte)(last | b >>> 2));
                    last = (b & 3) << 6;
                    ++state;
                    if (remaining-- <= 0 || --targetRemaining <= 0) break;
                    b = Decoder.nextByte(source, state, last, false);
                    if ((b & 0xF000) != 0) {
                        source.position(source.position() - 1);
                        continue;
                    }
                }
                if (state != 3) continue;
                target.put((byte)(last | b));
                state = 0;
                last = 0;
                --targetRemaining;
            }
            if (remaining > 0) {
                Decoder.drain(source, b, state, last);
            }
            this.last = last;
            this.state = state;
            this.lastPos = source.position();
        }

        private static void drain(ByteBuffer source, int b, int state, int last) {
            while (b != 65280 && source.remaining() > 0) {
                try {
                    b = Decoder.nextByte(source, state, last, true);
                }
                catch (IOException e) {
                    b = 0;
                }
                if (b == 65024) {
                    last = 65024;
                    continue;
                }
                if ((b & 0xF000) != 0) continue;
                source.position(source.position() - 1);
                break;
            }
            if (b == 65280) {
                while (source.remaining() > 0 && (b = (int)source.get()) != 10) {
                    if (b == 32 || b == 9 || b == 13) continue;
                    source.position(source.position() - 1);
                    break;
                }
            }
        }

        private static int drain(Object source, int pos, int limit, int b, int state, int last) {
            while (b != 65280 && limit > pos) {
                try {
                    b = Decoder.nextByte(source, pos++, state, last, true);
                }
                catch (IOException e) {
                    b = 0;
                }
                if (b == 65024) {
                    last = 65024;
                    continue;
                }
                if ((b & 0xF000) != 0) continue;
                --pos;
                break;
            }
            if (b == 65280) {
                while (limit > pos) {
                    if (source instanceof byte[]) {
                        b = ((byte[])source)[pos++] & 0xFF;
                    } else if (source instanceof String) {
                        b = ((String)source).charAt(pos++) & 0xFF;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if (b == 10) break;
                    if (b == 32 || b == 9 || b == 13) continue;
                    --pos;
                }
            }
            return pos;
        }

        private int decode(Object source, int sourcePos, int sourceLimit, byte[] target, int targetPos, int targetLimit) throws IOException {
            if (target == null) {
                throw new IllegalStateException();
            }
            int last = this.last;
            int state = this.state;
            int pos = sourcePos;
            int opos = targetPos;
            int limit = sourceLimit;
            int olimit = targetLimit;
            int b = 0;
            while (limit > pos && olimit > opos) {
                if ((b = Decoder.nextByte(source, pos++, state, last, false)) == 65024) {
                    last = 65024;
                    if (pos >= limit) break;
                    b = Decoder.nextByte(source, pos++, state, last, false);
                }
                if (b == 65280) {
                    state = 0;
                    last = 0;
                    break;
                }
                if (b == 64768) continue;
                if (state == 0) {
                    last = b << 2;
                    ++state;
                    if (pos >= limit) break;
                    if (((b = Decoder.nextByte(source, pos++, state, last, false)) & 0xF000) != 0) {
                        --pos;
                        continue;
                    }
                }
                if (state == 1) {
                    target[opos++] = (byte)(last | b >>> 4);
                    last = (b & 0xF) << 4;
                    ++state;
                    if (pos >= limit || opos >= olimit) break;
                    if (((b = Decoder.nextByte(source, pos++, state, last, false)) & 0xF000) != 0) {
                        --pos;
                        continue;
                    }
                }
                if (state == 2) {
                    target[opos++] = (byte)(last | b >>> 2);
                    last = (b & 3) << 6;
                    ++state;
                    if (pos >= limit || opos >= olimit) break;
                    if (((b = Decoder.nextByte(source, pos++, state, last, false)) & 0xF000) != 0) {
                        --pos;
                        continue;
                    }
                }
                if (state != 3) continue;
                target[opos++] = (byte)(last | b);
                state = 0;
                last = 0;
            }
            if (limit > pos) {
                pos = Decoder.drain(source, pos, limit, b, state, last);
            }
            this.last = last;
            this.state = state;
            this.lastPos = pos;
            return opos;
        }

        public int getLastInputPosition() {
            return this.lastPos;
        }

        public int decode(String source, int sourcePos, int sourceLimit, byte[] target, int targetPos, int targetLimit) throws IOException {
            return this.decode((Object)source, sourcePos, sourceLimit, target, targetPos, targetLimit);
        }

        public int decode(String source, byte[] target) throws IOException {
            return this.decode(source, 0, source.length(), target, 0, target.length);
        }

        public int decode(byte[] source, int sourcePos, int sourceLimit, byte[] target, int targetPos, int targetLimit) throws IOException {
            return this.decode((Object)source, sourcePos, sourceLimit, target, targetPos, targetLimit);
        }

        private static ByteBuffer decode(String source) throws IOException {
            int remainder = source.length() % 4;
            int size = (source.length() / 4 + (remainder == 0 ? 0 : 4 - remainder)) * 3;
            byte[] buffer = new byte[size];
            int actual = FlexBase64.createDecoder().decode(source, 0, source.length(), buffer, 0, size);
            return ByteBuffer.wrap(buffer, 0, actual);
        }

        private static ByteBuffer decode(byte[] source, int off, int limit) throws IOException {
            int len = limit - off;
            int remainder = len % 4;
            int size = (len / 4 + (remainder == 0 ? 0 : 4 - remainder)) * 3;
            byte[] buffer = new byte[size];
            int actual = FlexBase64.createDecoder().decode(source, off, limit, buffer, 0, size);
            return ByteBuffer.wrap(buffer, 0, actual);
        }

        private static ByteBuffer decode(ByteBuffer source) throws IOException {
            int len = source.remaining();
            int remainder = len % 4;
            int size = (len / 4 + (remainder == 0 ? 0 : 4 - remainder)) * 3;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            FlexBase64.createDecoder().decode(source, buffer);
            buffer.flip();
            return buffer;
        }
    }

    public static final class Encoder {
        private int state;
        private int last;
        private int count;
        private final boolean wrap;
        private int lastPos;

        private Encoder(boolean wrap) {
            this.wrap = wrap;
        }

        public void encode(ByteBuffer source, ByteBuffer target) {
            if (target == null) {
                throw new IllegalStateException();
            }
            int last = this.last;
            int state = this.state;
            boolean wrap = this.wrap;
            int count = this.count;
            byte[] ENCODING_TABLE = ENCODING_TABLE;
            int remaining = source.remaining();
            while (remaining > 0) {
                int require = 4 - state;
                int n = require = wrap && count >= 72 ? require + 2 : require;
                if (target.remaining() < require) break;
                int b = source.get() & 0xFF;
                if (state == 0) {
                    target.put(ENCODING_TABLE[b >>> 2]);
                    last = (b & 3) << 4;
                    ++state;
                    if (--remaining <= 0) break;
                    b = source.get() & 0xFF;
                }
                if (state == 1) {
                    target.put(ENCODING_TABLE[last | b >>> 4]);
                    last = (b & 0xF) << 2;
                    ++state;
                    if (--remaining <= 0) break;
                    b = source.get() & 0xFF;
                }
                if (state == 2) {
                    target.put(ENCODING_TABLE[last | b >>> 6]);
                    target.put(ENCODING_TABLE[b & 0x3F]);
                    state = 0;
                    last = 0;
                    --remaining;
                }
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target.putShort((short)3338);
            }
            this.count = count;
            this.last = last;
            this.state = state;
            this.lastPos = source.position();
        }

        public int encode(byte[] source, int pos, int limit, byte[] target, int opos, int olimit) {
            if (target == null) {
                throw new IllegalStateException();
            }
            int last = this.last;
            int state = this.state;
            int count = this.count;
            boolean wrap = this.wrap;
            byte[] ENCODING_TABLE = ENCODING_TABLE;
            while (limit > pos) {
                int require = 4 - state;
                int n = require = wrap && count >= 72 ? require + 2 : require;
                if (require + opos > olimit) break;
                int b = source[pos++] & 0xFF;
                if (state == 0) {
                    target[opos++] = ENCODING_TABLE[b >>> 2];
                    last = (b & 3) << 4;
                    ++state;
                    if (pos >= limit) break;
                    b = source[pos++] & 0xFF;
                }
                if (state == 1) {
                    target[opos++] = ENCODING_TABLE[last | b >>> 4];
                    last = (b & 0xF) << 2;
                    ++state;
                    if (pos >= limit) break;
                    b = source[pos++] & 0xFF;
                }
                if (state == 2) {
                    target[opos++] = ENCODING_TABLE[last | b >>> 6];
                    target[opos++] = ENCODING_TABLE[b & 0x3F];
                    state = 0;
                    last = 0;
                }
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            this.count = count;
            this.last = last;
            this.state = state;
            this.lastPos = pos;
            return opos;
        }

        private static String encodeString(byte[] source, int pos, int limit, boolean wrap) {
            int olimit;
            int remainder = (olimit = limit - pos) % 3;
            olimit = (olimit + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
            char[] target = new char[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
            int opos = 0;
            int last = 0;
            int count = 0;
            int state = 0;
            byte[] ENCODING_TABLE = ENCODING_TABLE;
            while (limit > pos) {
                int b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[b >>> 2];
                last = (b & 3) << 4;
                if (pos >= limit) {
                    state = 1;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 4];
                last = (b & 0xF) << 2;
                if (pos >= limit) {
                    state = 2;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 6];
                target[opos++] = (char)ENCODING_TABLE[b & 0x3F];
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            Encoder.complete(target, opos, state, last, wrap);
            try {
                if (STRING_CONSTRUCTOR != null) {
                    return (String)STRING_CONSTRUCTOR.newInstance(target, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String(target);
        }

        private static byte[] encodeBytes(byte[] source, int pos, int limit, boolean wrap) {
            int olimit;
            int remainder = (olimit = limit - pos) % 3;
            olimit = (olimit + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
            byte[] target = new byte[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
            int opos = 0;
            int count = 0;
            int last = 0;
            int state = 0;
            byte[] ENCODING_TABLE = ENCODING_TABLE;
            while (limit > pos) {
                int b = source[pos++] & 0xFF;
                target[opos++] = ENCODING_TABLE[b >>> 2];
                last = (b & 3) << 4;
                if (pos >= limit) {
                    state = 1;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = ENCODING_TABLE[last | b >>> 4];
                last = (b & 0xF) << 2;
                if (pos >= limit) {
                    state = 2;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = ENCODING_TABLE[last | b >>> 6];
                target[opos++] = ENCODING_TABLE[b & 0x3F];
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            Encoder.complete(target, opos, state, last, wrap);
            return target;
        }

        private static String encodeString(ByteBuffer source, boolean wrap) {
            int remaining;
            int remainder = (remaining = source.remaining()) % 3;
            int olimit = (remaining + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
            char[] target = new char[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
            int opos = 0;
            int last = 0;
            int state = 0;
            int count = 0;
            byte[] ENCODING_TABLE = ENCODING_TABLE;
            while (remaining > 0) {
                int b = source.get() & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[b >>> 2];
                last = (b & 3) << 4;
                if (--remaining <= 0) {
                    state = 1;
                    break;
                }
                b = source.get() & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 4];
                last = (b & 0xF) << 2;
                if (--remaining <= 0) {
                    state = 2;
                    break;
                }
                b = source.get() & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 6];
                target[opos++] = (char)ENCODING_TABLE[b & 0x3F];
                --remaining;
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            Encoder.complete(target, opos, state, last, wrap);
            try {
                if (STRING_CONSTRUCTOR != null) {
                    return (String)STRING_CONSTRUCTOR.newInstance(target, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String(target);
        }

        public int getLastInputPosition() {
            return this.lastPos;
        }

        public int complete(byte[] target, int pos) {
            if (this.state > 0) {
                target[pos++] = ENCODING_TABLE[this.last];
                for (int i = this.state; i < 3; ++i) {
                    target[pos++] = 61;
                }
                this.state = 0;
                this.last = 0;
            }
            if (this.wrap) {
                target[pos++] = 13;
                target[pos++] = 10;
            }
            return pos;
        }

        private static int complete(char[] target, int pos, int state, int last, boolean wrap) {
            if (state > 0) {
                target[pos++] = (char)ENCODING_TABLE[last];
                for (int i = state; i < 3; ++i) {
                    target[pos++] = 61;
                }
            }
            if (wrap) {
                target[pos++] = 13;
                target[pos++] = 10;
            }
            return pos;
        }

        private static int complete(byte[] target, int pos, int state, int last, boolean wrap) {
            if (state > 0) {
                target[pos++] = ENCODING_TABLE[last];
                for (int i = state; i < 3; ++i) {
                    target[pos++] = 61;
                }
            }
            if (wrap) {
                target[pos++] = 13;
                target[pos++] = 10;
            }
            return pos;
        }

        public void complete(ByteBuffer target) {
            if (this.state > 0) {
                target.put(ENCODING_TABLE[this.last]);
                for (int i = this.state; i < 3; ++i) {
                    target.put((byte)61);
                }
                this.state = 0;
                this.last = 0;
            }
            if (this.wrap) {
                target.putShort((short)3338);
            }
            this.count = 0;
        }
    }
}

