/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Random;
import org.xnio.Buffers;
import org.xnio.Pooled;

public abstract class WebSocket07FrameSinkChannel
extends StreamSinkFrameChannel {
    private final int maskingKey;
    private final Masker masker;
    private final long payloadSize;
    private boolean dataWritten = false;
    long toWrite;

    protected WebSocket07FrameSinkChannel(WebSocket07Channel wsChannel, WebSocketFrameType type, long payloadSize) {
        super(wsChannel, type);
        this.payloadSize = payloadSize;
        this.toWrite = payloadSize;
        if (wsChannel.isClient()) {
            this.maskingKey = new Random().nextInt();
            this.masker = new Masker(this.maskingKey);
        } else {
            this.masker = null;
            this.maskingKey = 0;
        }
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        this.dataWritten = true;
        if (this.masker != null) {
            this.masker.setMaskingKey(this.maskingKey);
        }
    }

    @Override
    protected void channelForciblyClosed() throws IOException {
        ((WebSocketChannel)this.getChannel()).sendClose();
    }

    private byte opCode() {
        if (this.dataWritten) {
            return 0;
        }
        switch (this.getType()) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(this.getType());
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        long payloadSize;
        if (this.payloadSize >= 0L && this.dataWritten) {
            return null;
        }
        Pooled start = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
        byte b0 = 0;
        if (this.isFinalFrameQueued() || this.payloadSize >= 0L) {
            b0 = (byte)(b0 | 0x80);
        }
        b0 = (byte)(b0 | (this.getRsv() & 7) << 4);
        b0 = (byte)(b0 | this.opCode() & 0xF);
        ByteBuffer header = (ByteBuffer)start.getResource();
        int maskKey = 0;
        if (this.masker != null) {
            maskKey = (byte)(maskKey | 0x80);
        }
        if ((payloadSize = this.payloadSize >= 0L ? this.payloadSize : (long)this.getBuffer().remaining()) <= 125L) {
            header.put(b0);
            header.put((byte)((payloadSize | (long)maskKey) & 0xFFL));
        } else if (payloadSize <= 65535L) {
            header.put(b0);
            header.put((byte)((0x7E | maskKey) & 0xFF));
            header.put((byte)(payloadSize >>> 8 & 0xFFL));
            header.put((byte)(payloadSize & 0xFFL));
        } else {
            header.put(b0);
            header.put((byte)((0x7F | maskKey) & 0xFF));
            header.putLong(payloadSize);
        }
        if (this.masker != null) {
            header.put((byte)(this.maskingKey >> 24 & 0xFF));
            header.put((byte)(this.maskingKey >> 16 & 0xFF));
            header.put((byte)(this.maskingKey >> 8 & 0xFF));
            header.put((byte)(this.maskingKey & 0xFF));
        }
        header.flip();
        return new SendFrameHeader(0, (Pooled<ByteBuffer>)start);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.toWrite >= 0L && Buffers.remaining((Buffer[])srcs) > this.toWrite) {
            throw WebSocketMessages.MESSAGES.messageOverflow();
        }
        if (this.masker == null) {
            return super.write(srcs, offset, length);
        }
        Pooled buffer = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
        try {
            long written;
            ByteBuffer[] copy = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                copy[i] = srcs[offset + i].duplicate();
            }
            Buffers.copy((ByteBuffer)((ByteBuffer)buffer.getResource()), (ByteBuffer[])copy, (int)0, (int)length);
            ((ByteBuffer)buffer.getResource()).flip();
            this.masker.beforeWrite((ByteBuffer)buffer.getResource(), 0, ((ByteBuffer)buffer.getResource()).remaining());
            long toAllocate = written = (long)super.write((ByteBuffer)buffer.getResource());
            for (int i = offset; i < length; ++i) {
                ByteBuffer thisBuf = srcs[i];
                if (toAllocate < (long)thisBuf.remaining()) {
                    thisBuf.position((int)((long)thisBuf.position() + toAllocate));
                    break;
                }
                toAllocate -= (long)thisBuf.remaining();
                thisBuf.position(thisBuf.limit());
            }
            this.toWrite -= written;
            long l = written;
            return l;
        }
        finally {
            buffer.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.toWrite >= 0L && (long)src.remaining() > this.toWrite) {
            throw WebSocketMessages.MESSAGES.messageOverflow();
        }
        if (this.masker == null) {
            return super.write(src);
        }
        Pooled buffer = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
        try {
            ByteBuffer copy = src.duplicate();
            Buffers.copy((ByteBuffer)((ByteBuffer)buffer.getResource()), (ByteBuffer)copy);
            ((ByteBuffer)buffer.getResource()).flip();
            this.masker.beforeWrite((ByteBuffer)buffer.getResource(), 0, ((ByteBuffer)buffer.getResource()).remaining());
            int written = super.write((ByteBuffer)buffer.getResource());
            src.position(src.position() + written);
            this.toWrite -= (long)written;
            int n = written;
            return n;
        }
        finally {
            buffer.free();
        }
    }
}

