/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import io.undertow.util.ImmediatePooled;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;

public final class Http2OpenListener
implements ChannelListener<StreamConnection>,
OpenListener {
    private static final String PROTOCOL_KEY = Http2OpenListener.class.getName() + ".protocol";
    private static final String HTTP2 = "h2-14";
    private static final String HTTP_1_1 = "http/1.1";
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private final HttpOpenListener delegate;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;

    public Http2OpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY, null);
    }

    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this(pool, undertowOptions, null);
    }

    public Http2OpenListener(Pool<ByteBuffer> pool, HttpOpenListener httpDelegate) {
        this(pool, OptionMap.EMPTY, httpDelegate);
    }

    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, HttpOpenListener httpDelegate) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
        this.delegate = httpDelegate;
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", channel.getPeerAddress());
        }
        final PotentialHttp2Connection potentialConnection = new PotentialHttp2Connection(channel);
        channel.getSourceChannel().setReadListener((ChannelListener)potentialConnection);
        final SSLEngine sslEngine = JsseXnioSsl.getSslEngine((SslConnection)((SslConnection)channel));
        String existing = (String)sslEngine.getSession().getValue(PROTOCOL_KEY);
        if (existing != null) {
            UndertowLogger.REQUEST_LOGGER.debug("Resuming existing session, not doing NPN negotiation");
            if (existing.equals(HTTP2)) {
                Http2Channel sc = new Http2Channel(channel, this.bufferPool, new ImmediatePooled<ByteBuffer>(ByteBuffer.wrap(new byte[0])), false, false, this.undertowOptions);
                sc.getReceiveSetter().set((ChannelListener)new Http2ReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize, this.statisticsEnabled ? this.connectorStatistics : null));
                sc.resumeReceives();
            } else {
                if (this.delegate == null) {
                    UndertowLogger.REQUEST_IO_LOGGER.couldNotInitiateHttp2Connection();
                    IoUtils.safeClose((Closeable)channel);
                    return;
                }
                channel.getSourceChannel().setReadListener(null);
                this.delegate.handleEvent(channel);
            }
        } else {
            ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)new ALPN.ServerProvider(){

                public void unsupported() {
                    potentialConnection.selected = Http2OpenListener.HTTP_1_1;
                }

                public String select(List<String> strings) {
                    ALPN.remove((SSLEngine)sslEngine);
                    for (String s : strings) {
                        if (!s.equals(Http2OpenListener.HTTP2)) continue;
                        potentialConnection.selected = s;
                        sslEngine.getSession().putValue(PROTOCOL_KEY, s);
                        return s;
                    }
                    sslEngine.getSession().putValue(PROTOCOL_KEY, Http2OpenListener.HTTP_1_1);
                    potentialConnection.selected = Http2OpenListener.HTTP_1_1;
                    return Http2OpenListener.HTTP_1_1;
                }
            });
            potentialConnection.handleEvent((StreamSourceChannel)channel.getSourceChannel());
        }
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        if (this.delegate != null) {
            this.delegate.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    private class PotentialHttp2Connection
    implements ChannelListener<StreamSourceChannel> {
        private String selected;
        private final StreamConnection channel;

        private PotentialHttp2Connection(StreamConnection channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(StreamSourceChannel source) {
            Pooled buffer = Http2OpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read((ByteBuffer)buffer.getResource())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    ((ByteBuffer)buffer.getResource()).flip();
                    if (Http2OpenListener.HTTP2.equals(this.selected)) {
                        Http2Channel channel = new Http2Channel(this.channel, (Pool<ByteBuffer>)Http2OpenListener.this.bufferPool, (Pooled<ByteBuffer>)buffer, false, false, Http2OpenListener.this.undertowOptions);
                        Integer idleTimeout = (Integer)Http2OpenListener.this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
                        if (idleTimeout != null && idleTimeout > 0) {
                            channel.setIdleTimeout(idleTimeout.intValue());
                        }
                        if (Http2OpenListener.this.statisticsEnabled) {
                            this.channel.getSinkChannel().setConduit((StreamSinkConduit)new BytesSentStreamSinkConduit(this.channel.getSinkChannel().getConduit(), Http2OpenListener.this.connectorStatistics.sentAccumulator()));
                            this.channel.getSourceChannel().setConduit((StreamSourceConduit)new BytesReceivedStreamSourceConduit(this.channel.getSourceChannel().getConduit(), Http2OpenListener.this.connectorStatistics.sentAccumulator()));
                        }
                        free = false;
                        channel.getReceiveSetter().set((ChannelListener)new Http2ReceiveListener(Http2OpenListener.this.rootHandler, Http2OpenListener.this.getUndertowOptions(), Http2OpenListener.this.bufferSize, Http2OpenListener.this.connectorStatistics));
                        channel.resumeReceives();
                        return;
                    }
                    if (Http2OpenListener.HTTP_1_1.equals(this.selected) || res > 0) {
                        if (Http2OpenListener.this.delegate == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.couldNotInitiateHttp2Connection();
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        this.channel.getSourceChannel().setReadListener(null);
                        if (res > 0) {
                            PushBackStreamSourceConduit pushBackStreamSourceConduit = new PushBackStreamSourceConduit(this.channel.getSourceChannel().getConduit());
                            this.channel.getSourceChannel().setConduit((StreamSourceConduit)pushBackStreamSourceConduit);
                            pushBackStreamSourceConduit.pushBack(buffer);
                            free = false;
                        }
                        Http2OpenListener.this.delegate.handleEvent(this.channel);
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.free();
                }
            }
        }
    }
}

