/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.ajp.AjpClientExchange;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSourceChannel;
import io.undertow.protocols.ajp.AjpClientChannel;
import io.undertow.protocols.ajp.AjpClientRequestClientStreamSinkChannel;
import io.undertow.protocols.ajp.AjpClientResponseStreamSourceChannel;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Headers;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

class AjpClientConnection
extends AbstractAttachable
implements Closeable,
ClientConnection {
    public final ChannelListener<AjpClientRequestClientStreamSinkChannel> requestFinishListener = new ChannelListener<AjpClientRequestClientStreamSinkChannel>(){

        public void handleEvent(AjpClientRequestClientStreamSinkChannel channel) {
            AjpClientConnection.this.currentRequest.terminateRequest();
        }
    };
    public final ChannelListener<AjpClientResponseStreamSourceChannel> responseFinishedListener = new ChannelListener<AjpClientResponseStreamSourceChannel>(){

        public void handleEvent(AjpClientResponseStreamSourceChannel channel) {
            AjpClientConnection.this.currentRequest.terminateResponse();
        }
    };
    private final Deque<AjpClientExchange> pendingQueue = new ArrayDeque<AjpClientExchange>();
    private AjpClientExchange currentRequest;
    private final OptionMap options;
    private final AjpClientChannel connection;
    private final Pool<ByteBuffer> bufferPool;
    private static final int UPGRADED = 0x10000000;
    private static final int UPGRADE_REQUESTED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private int state;
    private final ChannelListener.SimpleSetter<AjpClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final ClientReceiveListener clientReceiveListener = new ClientReceiveListener();

    AjpClientConnection(AjpClientChannel connection, OptionMap options, Pool<ByteBuffer> bufferPool) {
        this.options = options;
        this.connection = connection;
        this.bufferPool = bufferPool;
        connection.addCloseTask(new ChannelListener<AjpClientChannel>(){

            public void handleEvent(AjpClientChannel channel) {
                ChannelListeners.invokeChannelListener((Channel)AjpClientConnection.this, (ChannelListener)AjpClientConnection.this.closeSetter.get());
            }
        });
        connection.getReceiveSetter().set((ChannelListener)new ClientReceiveListener());
        connection.resumeReceives();
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.connection.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends AjpClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.connection.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.connection.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.connection.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.connection.setOption(option, value);
    }

    @Override
    public boolean isUpgraded() {
        return Bits.anyAreSet((int)this.state, (int)0x30000000);
    }

    @Override
    public boolean isPushSupported() {
        return false;
    }

    @Override
    public boolean isMultiplexingSupported() {
        return false;
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        if (Bits.anyAreSet((int)this.state, (int)-268435456)) {
            clientCallback.failed(UndertowClientMessages.MESSAGES.invalidConnectionState());
            return;
        }
        AjpClientExchange AjpClientExchange2 = new AjpClientExchange(clientCallback, request, this);
        if (this.currentRequest == null) {
            this.initiateRequest(AjpClientExchange2);
        } else {
            this.pendingQueue.add(AjpClientExchange2);
        }
    }

    private void initiateRequest(AjpClientExchange AjpClientExchange2) {
        this.currentRequest = AjpClientExchange2;
        ClientRequest request = AjpClientExchange2.getRequest();
        String connectionString = request.getRequestHeaders().getFirst(Headers.CONNECTION);
        if (connectionString != null) {
            if (Headers.CLOSE.equalToString(connectionString)) {
                this.state |= 0x40000000;
            }
        } else if (request.getProtocol() != Protocols.HTTP_1_1) {
            this.state |= 0x40000000;
        }
        if (request.getRequestHeaders().contains(Headers.UPGRADE)) {
            this.state |= 0x20000000;
        }
        long length = 0L;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            length = Long.parseLong(fixedLengthString);
        } else if (transferEncodingString != null) {
            length = -1L;
        }
        AjpClientRequestClientStreamSinkChannel sinkChannel = this.connection.sendRequest(request.getMethod(), request.getPath(), request.getProtocol(), request.getRequestHeaders(), request, this.requestFinishListener);
        this.currentRequest.setRequestChannel(sinkChannel);
        AjpClientExchange2.invokeReadReadyCallback(AjpClientExchange2);
        if (length == 0L) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    this.handleFailedFlush(sinkChannel);
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleFailedFlush(AjpClientRequestClientStreamSinkChannel sinkChannel) {
        sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

            public void handleException(StreamSinkChannel channel, IOException exception) {
                AjpClientConnection.this.handleError(exception);
            }
        }));
        sinkChannel.resumeWrites();
    }

    private void handleError(IOException exception) {
        this.currentRequest.setFailed(exception);
        IoUtils.safeClose((Closeable)((Object)this.connection));
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)Integer.MIN_VALUE)) {
            return;
        }
        this.state |= 0xC0000000;
        this.connection.close();
    }

    public void requestDone() {
        this.currentRequest = null;
        if (Bits.anyAreSet((int)this.state, (int)0x40000000)) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
        } else if (Bits.anyAreSet((int)this.state, (int)0x20000000)) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
            return;
        }
        AjpClientExchange next = this.pendingQueue.poll();
        if (next != null) {
            this.initiateRequest(next);
        }
    }

    public void requestClose() {
        this.state |= 0x40000000;
    }

    class ClientReceiveListener
    implements ChannelListener<AjpClientChannel> {
        ClientReceiveListener() {
        }

        public void handleEvent(AjpClientChannel channel) {
            try {
                AbstractAjpClientStreamSourceChannel result = (AbstractAjpClientStreamSourceChannel)channel.receive();
                if (result == null) {
                    return;
                }
                if (result instanceof AjpClientResponseStreamSourceChannel) {
                    AjpClientResponseStreamSourceChannel response = (AjpClientResponseStreamSourceChannel)result;
                    response.setFinishListener(AjpClientConnection.this.responseFinishedListener);
                    ClientResponse cr = new ClientResponse(response.getStatusCode(), response.getReasonPhrase(), AjpClientConnection.this.currentRequest.getRequest().getProtocol(), response.getHeaders());
                    if (response.getStatusCode() == 100) {
                        AjpClientConnection.this.currentRequest.setContinueResponse(cr);
                    } else {
                        AjpClientConnection.this.currentRequest.setResponseChannel(response);
                        AjpClientConnection.this.currentRequest.setResponse(cr);
                    }
                } else {
                    Channels.drain((StreamSourceChannel)result, (long)Long.MAX_VALUE);
                }
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)((Object)AjpClientConnection.this.connection));
                AjpClientConnection.this.currentRequest.setFailed(e instanceof IOException ? (IOException)e : new IOException(e));
            }
        }
    }
}

