/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.client.ClientConnection;
import io.undertow.server.ServerConnection;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.sql.SQLException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="UT")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)UndertowLogger.class.getPackage().getName());
    public static final UndertowLogger CLIENT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)ClientConnection.class.getPackage().getName());
    public static final UndertowLogger REQUEST_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".request"));
    public static final UndertowLogger PROXY_REQUEST_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".proxy"));
    public static final UndertowLogger REQUEST_DUMPER_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".request.dump"));
    public static final UndertowLogger REQUEST_IO_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".request.io"));

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5001, value="An exception occurred processing the request")
    public void exceptionProcessingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5002, value="Exception reading file %s: %s")
    public void exceptionReadingFile(File var1, IOException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5003, value="IOException reading from channel")
    public void ioExceptionReadingFromChannel(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5005, value="Cannot remove uploaded file %s")
    public void cannotRemoveUploadedFile(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5006, value="Connection from %s terminated as request header was larger than %s")
    public void requestHeaderWasTooLarge(SocketAddress var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5007, value="Request was not fully consumed")
    public void requestWasNotFullyConsumed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5008, value="An invalid token '%s' with value '%s' has been received.")
    public void invalidTokenReceived(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5009, value="A mandatory token %s is missing from the request.")
    public void missingAuthorizationToken(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5010, value="Verification of authentication tokens for user '%s' has failed using mechanism '%s'.")
    public void authenticationFailed(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5011, value="Ignoring AJP request with prefix %s")
    public void ignoringAjpRequestWithPrefixCode(byte var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5013, value="An IOException occurred")
    public void ioException(@Cause IOException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5014, value="Failed to parse HTTP request")
    public void failedToParseRequest(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5015, value="Error rotating access log")
    public void errorRotatingAccessLog(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5016, value="Error writing access log")
    public void errorWritingAccessLog(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5017, value="Unknown variable %s")
    public void unknownVariable(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5018, value="Exception invoking close listener %s")
    public void exceptionInvokingCloseListener(ServerConnection.CloseListener var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5019, value="Cannot upgrade connection")
    public void cannotUpgradeConnection(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5020, value="Error writing JDBC log")
    public void errorWritingJDBCLog(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5021, value="Proxy request to %s timed out")
    public void proxyRequestTimedOut(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5022, value="Exception generating error page %s")
    public void exceptionGeneratingErrorPage(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5023, value="Exception handling request to %s")
    public void exceptionHandlingRequest(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5024, value="Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work")
    public void couldNotRegisterChangeListener(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5025, value="Could not initiate SPDY connection and no HTTP fallback defined")
    public void couldNotInitiateSpdyConnection();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5026, value="Jetty ALPN support not found on boot class path, %s client will not be available.")
    public void jettyALPNNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5027, value="Timing out request to %s")
    public void timingOutRequest(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5028, value="Proxy request to %s failed")
    public void proxyRequestFailed(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5030, value="Proxy request to %s could not resolve a backend server")
    public void proxyRequestFailedToResolveBackend(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5031, value="Proxy request to %s could not connect to backend server %s")
    public void proxyFailedToConnectToBackend(String var1, URI var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5032, value="Listener not making progress on framed channel, closing channel to prevent infinite loop")
    public void listenerNotProgressing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5033, value="Failed to initiate HTTP2 connection")
    public void couldNotInitiateHttp2Connection();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5034, value="Remote endpoint failed to send initial settings frame in HTTP2 connection, frame type %s")
    public void remoteEndpointFailedToSendInitialSettings(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5035, value="Closing channel because of parse timeout for remote address %s")
    public void parseRequestTimedOut(SocketAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5036, value="ALPN negotiation failed for %s and no fallback defined, closing connection")
    public void noALPNFallback(SocketAddress var1);
}

