/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Base64;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public class Hybi07Handshake
extends Handshake {
    public static final String MAGIC_NUMBER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    protected Hybi07Handshake(WebSocketVersion version, Set<String> subprotocols, boolean allowExtensions) {
        super(version, "SHA1", MAGIC_NUMBER, subprotocols);
        this.allowExtensions = allowExtensions;
    }

    public Hybi07Handshake(Set<String> subprotocols, boolean allowExtensions) {
        this(WebSocketVersion.V07, subprotocols, allowExtensions);
    }

    public Hybi07Handshake() {
        this(WebSocketVersion.V07, Collections.emptySet(), false);
    }

    @Override
    public boolean matches(WebSocketHttpExchange exchange) {
        if (exchange.getRequestHeader("Sec-WebSocket-Key") != null && exchange.getRequestHeader("Sec-WebSocket-Version") != null) {
            return exchange.getRequestHeader("Sec-WebSocket-Version").equals(this.getVersion().toHttpHeaderValue());
        }
        return false;
    }

    @Override
    protected void handshakeInternal(WebSocketHttpExchange exchange) {
        String origin = exchange.getRequestHeader("Sec-WebSocket-Origin");
        if (origin != null) {
            exchange.setResponseHeader("Sec-WebSocket-Origin", origin);
        }
        this.selectSubprotocol(exchange);
        this.selectExtensions(exchange);
        exchange.setResponseHeader("Sec-WebSocket-Location", Hybi07Handshake.getWebSocketLocation(exchange));
        String key = exchange.getRequestHeader("Sec-WebSocket-Key");
        try {
            String solution = this.solve(key);
            exchange.setResponseHeader("Sec-WebSocket-Accept", solution);
            this.performUpgrade(exchange);
        }
        catch (NoSuchAlgorithmException e) {
            IoUtils.safeClose((Closeable)exchange);
            exchange.endExchange();
            return;
        }
    }

    protected final String solve(String nonceBase64) throws NoSuchAlgorithmException {
        String concat = nonceBase64.trim() + this.getMagicNumber();
        MessageDigest digest = MessageDigest.getInstance(this.getHashAlgorithm());
        digest.update(concat.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBytes(digest.digest()).trim();
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, StreamConnection channel, Pool<ByteBuffer> pool) {
        return new WebSocket07Channel(channel, pool, Hybi07Handshake.getWebSocketLocation(exchange), exchange.getResponseHeader("Sec-WebSocket-Protocol"), false, this.allowExtensions, this.initExtensions(exchange), exchange.getPeerConnections());
    }
}

