/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.util.FlexBase64;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.BoundChannel;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

public class Http2ClearClientProvider
implements ClientProvider {
    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("h2c"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        URI upgradeUri;
        try {
            upgradeUri = new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            listener.failed(new IOException(e));
            return;
        }
        Map<String, String> headers = this.createHeaders(options, bufferPool, uri);
        HttpUpgrade.performUpgrade((XnioWorker)worker, (InetSocketAddress)bindAddress, (URI)upgradeUri, headers, (ChannelListener)new Http2ClearOpenListener(bufferPool, options, listener, uri.getHost()), null, (OptionMap)options, null).addNotifier((IoFuture.Notifier)new FailedNotifier(listener), null);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        URI upgradeUri;
        try {
            upgradeUri = new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            listener.failed(new IOException(e));
            return;
        }
        if (bindAddress != null) {
            ioThread.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort()), (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    Map headers = Http2ClearClientProvider.this.createHeaders(options, (Pool<ByteBuffer>)bufferPool, uri);
                    HttpUpgrade.performUpgrade((StreamConnection)channel, (URI)upgradeUri, (Map)headers, (ChannelListener)new Http2ClearOpenListener((Pool<ByteBuffer>)bufferPool, options, listener, uri.getHost()), null).addNotifier((IoFuture.Notifier)new FailedNotifier(listener), null);
                }
            }, (ChannelListener)new ChannelListener<BoundChannel>(){

                public void handleEvent(BoundChannel channel) {
                }
            }, options).addNotifier((IoFuture.Notifier)new FailedNotifier(listener), null);
        } else {
            ioThread.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort()), (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    Map headers = Http2ClearClientProvider.this.createHeaders(options, (Pool<ByteBuffer>)bufferPool, uri);
                    HttpUpgrade.performUpgrade((StreamConnection)channel, (URI)upgradeUri, (Map)headers, (ChannelListener)new Http2ClearOpenListener((Pool<ByteBuffer>)bufferPool, options, listener, uri.getHost()), null).addNotifier((IoFuture.Notifier)new FailedNotifier(listener), null);
                }
            }, (ChannelListener)new ChannelListener<BoundChannel>(){

                public void handleEvent(BoundChannel channel) {
                }
            }, options).addNotifier((IoFuture.Notifier)new FailedNotifier(listener), null);
        }
    }

    private Map<String, String> createHeaders(OptionMap options, Pool<ByteBuffer> bufferPool, URI uri) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("HTTP2-Settings", this.createSettingsFrame(options, bufferPool));
        headers.put("Upgrade", "h2c");
        headers.put("Connection", "Upgrade, HTTP2-Settings");
        headers.put("Host", uri.getHost());
        headers.put("X-HTTP2-connect-only", "connect");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSettingsFrame(OptionMap options, Pool<ByteBuffer> bufferPool) {
        Pooled b = bufferPool.allocate();
        try {
            ByteBuffer currentBuffer = (ByteBuffer)b.getResource();
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 1, (Integer)options.get(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 2, (Boolean)options.get(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH) != false ? 1 : 0);
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 3, (Integer)options.get(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 4, (Integer)options.get(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 5, (Integer)options.get(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE));
            }
            if (options.contains(UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE)) {
                Http2ClearClientProvider.pushOption(currentBuffer, 6, (Integer)options.get(UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE));
            }
            currentBuffer.flip();
            String string = FlexBase64.encodeStringURL(currentBuffer, false);
            return string;
        }
        finally {
            b.free();
        }
    }

    private static void pushOption(ByteBuffer currentBuffer, int id, int value) {
        currentBuffer.put((byte)(id >> 8 & 0xFF));
        currentBuffer.put((byte)(id & 0xFF));
        currentBuffer.put((byte)(value >> 24 & 0xFF));
        currentBuffer.put((byte)(value >> 16 & 0xFF));
        currentBuffer.put((byte)(value >> 8 & 0xFF));
        currentBuffer.put((byte)(value & 0xFF));
    }

    private static class FailedNotifier
    implements IoFuture.Notifier<StreamConnection, Object> {
        private final ClientCallback<ClientConnection> listener;

        public FailedNotifier(ClientCallback<ClientConnection> listener) {
            this.listener = listener;
        }

        public void notify(IoFuture<? extends StreamConnection> ioFuture, Object attachment) {
            if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                this.listener.failed(ioFuture.getException());
            }
        }
    }

    private static class Http2ClearOpenListener
    implements ChannelListener<StreamConnection> {
        private final Pool<ByteBuffer> bufferPool;
        private final OptionMap options;
        private final ClientCallback<ClientConnection> listener;
        private final String defaultHost;

        public Http2ClearOpenListener(Pool<ByteBuffer> bufferPool, OptionMap options, ClientCallback<ClientConnection> listener, String defaultHost) {
            this.bufferPool = bufferPool;
            this.options = options;
            this.listener = listener;
            this.defaultHost = defaultHost;
        }

        public void handleEvent(StreamConnection channel) {
            Http2Channel http2Channel = new Http2Channel(channel, null, this.bufferPool, null, true, true, this.options);
            Http2ClientConnection http2ClientConnection = new Http2ClientConnection(http2Channel, true, this.defaultHost);
            this.listener.completed(http2ClientConnection);
        }
    }
}

