/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.encoding.ContentEncodedResource;
import io.undertow.server.handlers.encoding.ContentEncodedResourceManager;
import io.undertow.server.handlers.resource.DirectoryUtils;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ByteRange;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import io.undertow.util.RedirectBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResourceHandler
implements HttpHandler {
    private final List<String> welcomeFiles = new CopyOnWriteArrayList<String>(new String[]{"index.html", "index.htm", "default.html", "default.htm"});
    private volatile boolean directoryListingEnabled = false;
    private volatile boolean canonicalizePaths = true;
    private volatile MimeMappings mimeMappings = MimeMappings.DEFAULT;
    private volatile Predicate cachable = Predicates.truePredicate();
    private volatile Predicate allowed = Predicates.truePredicate();
    private volatile ResourceManager resourceManager;
    private volatile Integer cacheTime;
    private volatile ContentEncodedResourceManager contentEncodedResourceManager;
    private final HttpHandler next;

    public ResourceHandler(ResourceManager resourceManager) {
        this(resourceManager, ResponseCodeHandler.HANDLE_404);
    }

    public ResourceHandler(ResourceManager resourceManager, HttpHandler next) {
        this.resourceManager = resourceManager;
        this.next = next;
    }

    @Deprecated
    public ResourceHandler() {
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(Methods.GET) || exchange.getRequestMethod().equals(Methods.POST)) {
            this.serveResource(exchange, true);
        } else if (exchange.getRequestMethod().equals(Methods.HEAD)) {
            this.serveResource(exchange, false);
        } else {
            exchange.setResponseCode(405);
            exchange.endExchange();
        }
    }

    private void serveResource(HttpServerExchange exchange, final boolean sendContent) throws Exception {
        if (DirectoryUtils.sendRequestedBlobs(exchange)) {
            return;
        }
        if (!this.allowed.resolve(exchange)) {
            exchange.setResponseCode(403);
            exchange.endExchange();
            return;
        }
        ResponseCache cache = exchange.getAttachment(ResponseCache.ATTACHMENT_KEY);
        boolean cachable = this.cachable.resolve(exchange);
        if (cachable && this.cacheTime != null) {
            exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "public, max-age=" + this.cacheTime);
            long date = System.currentTimeMillis() + (long)this.cacheTime.intValue();
            String dateHeader = DateUtils.toDateString(new Date(date));
            exchange.getResponseHeaders().put(Headers.EXPIRES, dateHeader);
        }
        if (cache != null && cachable && cache.tryServeResponse()) {
            return;
        }
        HttpHandler dispatchTask = new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Resource resource = null;
                try {
                    if (File.separatorChar == '/' || !exchange.getRelativePath().contains(File.separator)) {
                        resource = ResourceHandler.this.resourceManager.getResource(ResourceHandler.this.canonicalize(exchange.getRelativePath()));
                    }
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.setResponseCode(500);
                    exchange.endExchange();
                    return;
                }
                if (resource == null) {
                    ResourceHandler.this.next.handleRequest(exchange);
                    return;
                }
                if (resource.isDirectory()) {
                    Resource indexResource;
                    try {
                        indexResource = ResourceHandler.this.getIndexFiles(ResourceHandler.this.resourceManager, resource.getPath(), ResourceHandler.this.welcomeFiles);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange.setResponseCode(500);
                        exchange.endExchange();
                        return;
                    }
                    if (indexResource == null) {
                        if (ResourceHandler.this.directoryListingEnabled) {
                            DirectoryUtils.renderDirectoryListing(exchange, resource);
                            return;
                        }
                        exchange.setResponseCode(403);
                        exchange.endExchange();
                        return;
                    }
                    if (!exchange.getRequestPath().endsWith("/")) {
                        exchange.setResponseCode(302);
                        exchange.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange, exchange.getRelativePath() + "/", true));
                        exchange.endExchange();
                        return;
                    }
                    resource = indexResource;
                } else if (exchange.getRelativePath().endsWith("/")) {
                    exchange.setResponseCode(404);
                    exchange.endExchange();
                    return;
                }
                ETag etag = resource.getETag();
                Date lastModified = resource.getLastModified();
                if (!ETagUtils.handleIfMatch(exchange, etag, false) || !DateUtils.handleIfUnmodifiedSince(exchange, lastModified)) {
                    exchange.setResponseCode(412);
                    exchange.endExchange();
                    return;
                }
                if (!ETagUtils.handleIfNoneMatch(exchange, etag, true) || !DateUtils.handleIfModifiedSince(exchange, lastModified)) {
                    exchange.setResponseCode(304);
                    exchange.endExchange();
                    return;
                }
                ContentEncodedResourceManager contentEncodedResourceManager = ResourceHandler.this.contentEncodedResourceManager;
                Long contentLength = resource.getContentLength();
                if (contentLength != null && !exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                    exchange.setResponseContentLength(contentLength);
                }
                ByteRange range = null;
                long start = -1L;
                long end = -1L;
                if (resource instanceof RangeAwareResource && ((RangeAwareResource)resource).isRangeSupported() && contentLength != null && contentEncodedResourceManager == null && (range = ByteRange.parse(exchange.getRequestHeaders().getFirst(Headers.RANGE))) != null && range.getRanges() == 1) {
                    long toWrite;
                    start = range.getStart(0);
                    end = range.getEnd(0);
                    if (start == -1L) {
                        toWrite = end;
                        if (toWrite >= 0L) {
                            exchange.setResponseContentLength(toWrite);
                        } else {
                            range = null;
                        }
                        start = contentLength - end;
                        end = contentLength;
                    } else if (end == -1L) {
                        toWrite = contentLength - start;
                        if (toWrite >= 0L) {
                            exchange.setResponseContentLength(toWrite);
                        } else {
                            range = null;
                        }
                        end = contentLength;
                    } else {
                        toWrite = end - start + 1L;
                        exchange.setResponseContentLength(toWrite);
                    }
                    if (range != null) {
                        exchange.setResponseCode(206);
                        exchange.getResponseHeaders().put(Headers.CONTENT_RANGE, range.getStart(0) + "-" + range.getEnd(0) + "/" + contentLength);
                    }
                }
                if (!exchange.getResponseHeaders().contains(Headers.CONTENT_TYPE)) {
                    String contentType = resource.getContentType(ResourceHandler.this.mimeMappings);
                    if (contentType != null) {
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
                    } else {
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/octet-stream");
                    }
                }
                if (lastModified != null) {
                    exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, resource.getLastModifiedString());
                }
                if (etag != null) {
                    exchange.getResponseHeaders().put(Headers.ETAG, etag.toString());
                }
                if (contentEncodedResourceManager != null) {
                    try {
                        ContentEncodedResource encoded = contentEncodedResourceManager.getResource(resource, exchange);
                        if (encoded != null) {
                            exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, encoded.getContentEncoding());
                            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, encoded.getResource().getContentLength());
                            encoded.getResource().serve(exchange.getResponseSender(), exchange, IoCallback.END_EXCHANGE);
                            return;
                        }
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange.setResponseCode(500);
                        exchange.endExchange();
                        return;
                    }
                }
                if (!sendContent) {
                    exchange.endExchange();
                } else if (range != null) {
                    ((RangeAwareResource)resource).serveRange(exchange.getResponseSender(), exchange, start, end, IoCallback.END_EXCHANGE);
                } else {
                    resource.serve(exchange.getResponseSender(), exchange, IoCallback.END_EXCHANGE);
                }
            }
        };
        if (exchange.isInIoThread()) {
            exchange.dispatch(dispatchTask);
        } else {
            dispatchTask.handleRequest(exchange);
        }
    }

    private Resource getIndexFiles(ResourceManager resourceManager, String base, List<String> possible) throws IOException {
        String realBase = base.endsWith("/") ? base : base + "/";
        for (String possibility : possible) {
            Resource index = resourceManager.getResource(this.canonicalize(realBase + possibility));
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private String canonicalize(String s) {
        if (this.canonicalizePaths) {
            return CanonicalPathUtils.canonicalize(s);
        }
        return s;
    }

    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ResourceHandler setDirectoryListingEnabled(boolean directoryListingEnabled) {
        this.directoryListingEnabled = directoryListingEnabled;
        return this;
    }

    public ResourceHandler addWelcomeFiles(String ... files) {
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public ResourceHandler setWelcomeFiles(String ... files) {
        this.welcomeFiles.clear();
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public ResourceHandler setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
        return this;
    }

    public Predicate getCachable() {
        return this.cachable;
    }

    public ResourceHandler setCachable(Predicate cachable) {
        this.cachable = cachable;
        return this;
    }

    public Predicate getAllowed() {
        return this.allowed;
    }

    public ResourceHandler setAllowed(Predicate allowed) {
        this.allowed = allowed;
        return this;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceHandler setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        return this;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public ResourceHandler setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public ContentEncodedResourceManager getContentEncodedResourceManager() {
        return this.contentEncodedResourceManager;
    }

    public ResourceHandler setContentEncodedResourceManager(ContentEncodedResourceManager contentEncodedResourceManager) {
        this.contentEncodedResourceManager = contentEncodedResourceManager;
        return this;
    }

    public boolean isCanonicalizePaths() {
        return this.canonicalizePaths;
    }

    public void setCanonicalizePaths(boolean canonicalizePaths) {
        this.canonicalizePaths = canonicalizePaths;
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String location;
        private final boolean allowDirectoryListing;

        private Wrapper(String location, boolean allowDirectoryListing) {
            this.location = location;
            this.allowDirectoryListing = allowDirectoryListing;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            PathResourceManager rm = new PathResourceManager(Paths.get(this.location, new String[0]), 1024L);
            ResourceHandler resourceHandler = new ResourceHandler(rm);
            resourceHandler.setDirectoryListingEnabled(this.allowDirectoryListing);
            return resourceHandler;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "resource";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("location", String.class);
            params.put("allow-listing", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("location");
        }

        @Override
        public String defaultParameter() {
            return "location";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("location"), (Boolean)config.get("allow-listing"));
        }
    }
}

