/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class URLUtils {
    private static final char PATH_SEPARATOR = '/';
    private static final QueryStringParser QUERY_STRING_PARSER = new QueryStringParser(){

        @Override
        void handle(HttpServerExchange exchange, String key, String value) {
            exchange.addQueryParam(key, value);
        }
    };
    private static final QueryStringParser PATH_PARAM_PARSER = new QueryStringParser(){

        @Override
        void handle(HttpServerExchange exchange, String key, String value) {
            exchange.addPathParam(key, value);
        }
    };

    private URLUtils() {
    }

    public static void parseQueryString(String string, HttpServerExchange exchange, String charset, boolean doDecode) {
        QUERY_STRING_PARSER.parse(string, exchange, charset, doDecode);
    }

    public static void parsePathParms(String string, HttpServerExchange exchange, String charset, boolean doDecode) {
        PATH_PARAM_PARSER.parse(string, exchange, charset, doDecode);
    }

    public static String decode(String s, String enc, boolean decodeSlash, StringBuilder buffer) {
        buffer.setLength(0);
        boolean needToChange = false;
        int numChars = s.length();
        int i = 0;
        boolean mightRequireSlashEscape = false;
        byte[] bytes = null;
        block9: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    buffer.append(' ');
                    ++i;
                    needToChange = true;
                    continue block9;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            char p1 = Character.toLowerCase(s.charAt(i + 1));
                            char p2 = Character.toLowerCase(s.charAt(i + 2));
                            int v = 0;
                            if (p1 >= '0' && p1 <= '9') {
                                v = p1 - 48 << 4;
                            } else if (p1 >= 'a' && p1 <= 'f') {
                                v = p1 - 97 + 10 << 4;
                            } else {
                                throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                            }
                            if (p2 >= '0' && p2 <= '9') {
                                v += p2 - 48;
                            } else if (p2 >= 'a' && p2 <= 'f') {
                                v += p2 - 97 + 10;
                            } else {
                                throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                            }
                            if (v < 0) {
                                throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                            }
                            if (v == 47 || v == 92) {
                                mightRequireSlashEscape = true;
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                        }
                        String decoded = new String(bytes, 0, pos, enc);
                        if (!decodeSlash && mightRequireSlashEscape) {
                            int decPos = 0;
                            for (int j = 0; j < decoded.length(); ++j) {
                                char decChar = decoded.charAt(j);
                                if (decChar == '/') {
                                    buffer.append(decoded.substring(decPos, j));
                                    buffer.append("%2F");
                                    decPos = j + 1;
                                    continue;
                                }
                                if (decChar != '\\') continue;
                                buffer.append(decoded.substring(decPos, j));
                                buffer.append("%5C");
                                decPos = j + 1;
                            }
                            buffer.append(decoded.substring(decPos));
                        } else {
                            buffer.append(decoded);
                        }
                        mightRequireSlashEscape = false;
                    }
                    catch (NumberFormatException e) {
                        throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
                    }
                    needToChange = true;
                    continue block9;
                }
            }
            buffer.append(c);
            ++i;
            if (c <= '\u007f' || needToChange) continue;
            try {
                char[] carray = s.toCharArray();
                byte[] buf = new byte[carray.length];
                for (int l = 0; l < buf.length; ++l) {
                    buf[l] = (byte)carray[l];
                }
                return new String(buf, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw UndertowMessages.MESSAGES.failedToDecodeURL(s, enc);
            }
        }
        return needToChange ? buffer.toString() : s;
    }

    public static String normalizeSlashes(String path) {
        StringBuilder builder = new StringBuilder(path);
        boolean modified = false;
        while (builder.length() > 0 && builder.length() != 1 && '/' == builder.charAt(builder.length() - 1)) {
            builder.deleteCharAt(builder.length() - 1);
            modified = true;
        }
        if (builder.length() == 0 || '/' != builder.charAt(0)) {
            builder.insert(0, '/');
            modified = true;
        }
        if (modified) {
            return builder.toString();
        }
        return path;
    }

    private static abstract class QueryStringParser {
        private QueryStringParser() {
        }

        void parse(String string, HttpServerExchange exchange, String charset, boolean doDecode) {
            try {
                int stringStart = 0;
                String attrName = null;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '=' && attrName == null) {
                        attrName = string.substring(stringStart, i);
                        stringStart = i + 1;
                        continue;
                    }
                    if (c != '&') continue;
                    if (attrName != null) {
                        this.handle(exchange, this.decode(charset, attrName, doDecode), this.decode(charset, string.substring(stringStart, i), doDecode));
                    } else {
                        this.handle(exchange, this.decode(charset, string.substring(stringStart, i), doDecode), "");
                    }
                    stringStart = i + 1;
                    attrName = null;
                }
                if (attrName != null) {
                    this.handle(exchange, this.decode(charset, attrName, doDecode), this.decode(charset, string.substring(stringStart, string.length()), doDecode));
                } else if (string.length() != stringStart) {
                    this.handle(exchange, this.decode(charset, string.substring(stringStart, string.length()), doDecode), "");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private String decode(String charset, String attrName, boolean doDecode) throws UnsupportedEncodingException {
            if (doDecode) {
                return URLDecoder.decode(attrName, charset);
            }
            return attrName;
        }

        abstract void handle(HttpServerExchange var1, String var2, String var3);
    }
}

