/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketInvalidCloseCodeException;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.UTF8Checker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

class WebSocket07CloseFrameSourceChannel
extends StreamSourceFrameChannel {
    WebSocket07CloseFrameSourceChannel(WebSocket07Channel wsChannel, int rsv, Masker masker, Pooled<ByteBuffer> pooled, long frameLength) {
        super(wsChannel, WebSocketFrameType.CLOSE, rsv, true, pooled, frameLength, masker, new CloseFrameValidatorChannelFunction(wsChannel));
    }

    WebSocket07CloseFrameSourceChannel(WebSocket07Channel wsChannel, int rsv, Pooled<ByteBuffer> pooled, long frameLength) {
        super(wsChannel, WebSocketFrameType.CLOSE, rsv, true, pooled, frameLength, null, new CloseFrameValidatorChannelFunction(wsChannel));
    }

    public static class CloseFrameValidatorChannelFunction
    extends UTF8Checker {
        private final WebSocket07Channel wsChannel;
        private int statusBytesRead;
        private int status;

        public CloseFrameValidatorChannelFunction(WebSocket07Channel wsChannel) {
            this.wsChannel = wsChannel;
        }

        @Override
        public void afterRead(ByteBuffer buf, int position, int length) throws IOException {
            int i;
            if (this.statusBytesRead < 2) {
                for (i = 0; this.statusBytesRead < 2 && i < length; ++i) {
                    this.status <<= 8;
                    this.status += buf.get(position + i) & 0xFF;
                    ++this.statusBytesRead;
                }
                if (this.statusBytesRead == 2 && (this.status >= 0 && this.status <= 999 || this.status >= 1004 && this.status <= 1006 || this.status >= 1012 && this.status <= 2999)) {
                    WebSocketInvalidCloseCodeException exception = WebSocketMessages.MESSAGES.invalidCloseFrameStatusCode(this.status);
                    this.wsChannel.markReadsBroken(exception);
                    throw exception;
                }
            }
            super.afterRead(buf, position + i, length - i);
        }
    }
}

