/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.ajp.AjpClientConnection;
import io.undertow.protocols.ajp.AjpClientChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class AjpClientProvider
implements ClientProvider {
    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("ajp"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioWorker worker, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            worker.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, options).addNotifier((IoFuture.Notifier)notifier, null);
        } else {
            worker.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, null, options).addNotifier((IoFuture.Notifier)notifier, null);
        }
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            ioThread.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, options).addNotifier((IoFuture.Notifier)notifier, null);
        } else {
            ioThread.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, null, options).addNotifier((IoFuture.Notifier)notifier, null);
        }
    }

    private void handleConnected(StreamConnection connection, ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        listener.completed(new AjpClientConnection(new AjpClientChannel(connection, bufferPool, options), options, bufferPool));
    }
}

