/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.util.FlexBase64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.xnio.SslClientAuthMode;

public class BasicSSLSessionInfo
implements SSLSessionInfo {
    private final byte[] sessionId;
    private final String cypherSuite;
    private final Certificate peerCertificate;
    private final X509Certificate certificate;

    public BasicSSLSessionInfo(byte[] sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this.sessionId = sessionId;
        this.cypherSuite = cypherSuite;
        if (certificate != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] certificateBytes = certificate.getBytes(StandardCharsets.US_ASCII);
            ByteArrayInputStream stream = new ByteArrayInputStream(certificateBytes);
            this.peerCertificate = cf.generateCertificate(stream);
            this.certificate = X509Certificate.getInstance(certificateBytes);
        } else {
            this.peerCertificate = null;
            this.certificate = null;
        }
    }

    public BasicSSLSessionInfo(String sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this(sessionId == null ? null : BasicSSLSessionInfo.base64Decode(sessionId), cypherSuite, certificate);
    }

    @Override
    public byte[] getSessionId() {
        if (this.sessionId == null) {
            return null;
        }
        byte[] copy = new byte[this.sessionId.length];
        System.arraycopy(this.sessionId, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public String getCipherSuite() {
        return this.cypherSuite;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.certificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return new Certificate[]{this.peerCertificate};
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.certificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return new X509Certificate[]{this.certificate};
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }

    private static byte[] base64Decode(String sessionId) {
        try {
            byte[] sessionIdData;
            ByteBuffer sessionIdBuffer = FlexBase64.decode(sessionId);
            if (sessionIdBuffer.hasArray()) {
                sessionIdData = sessionIdBuffer.array();
            } else {
                sessionIdData = new byte[sessionIdBuffer.remaining()];
                sessionIdBuffer.get(sessionIdData);
            }
            return sessionIdData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

