/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyControlFrameStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.nio.ByteBuffer;

class SpdyGoAwayStreamSinkChannel
extends SpdyControlFrameStreamSinkChannel {
    private final int status;
    private final int lastGoodStreamId;

    protected SpdyGoAwayStreamSinkChannel(SpdyChannel channel, int status, int lastGoodStreamId) {
        super(channel);
        this.status = status;
        this.lastGoodStreamId = lastGoodStreamId;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 7;
        SpdyProtocolUtils.putInt(buf, firstInt);
        SpdyProtocolUtils.putInt(buf, 8);
        SpdyProtocolUtils.putInt(buf, this.lastGoodStreamId);
        SpdyProtocolUtils.putInt(buf, this.status);
        buf.flip();
        return new SendFrameHeader(new ImmediatePooledByteBuffer(buf));
    }

    @Override
    protected boolean isLastFrame() {
        return true;
    }
}

