/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import java.util.ArrayList;
import java.util.List;

public class ByteRange {
    private final List<Range> ranges;

    public ByteRange(List<Range> ranges) {
        this.ranges = ranges;
    }

    public int getRanges() {
        return this.ranges.size();
    }

    public long getStart(int range) {
        return this.ranges.get(range).getStart();
    }

    public long getEnd(int range) {
        return this.ranges.get(range).getEnd();
    }

    public static ByteRange parse(String rangeHeader) {
        String[] parts;
        if (rangeHeader == null || rangeHeader.length() < 7) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes=")) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String part : parts = rangeHeader.substring(6).split(",")) {
            try {
                long end;
                int index = part.indexOf(45);
                if (index == 0) {
                    long val = Long.parseLong(part.substring(1));
                    if (val < 0L) {
                        UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", rangeHeader);
                        return null;
                    }
                    ranges.add(new Range(-1L, val));
                    continue;
                }
                if (index == -1) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", rangeHeader);
                    return null;
                }
                long start = Long.parseLong(part.substring(0, index));
                if (start < 0L) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", rangeHeader);
                    return null;
                }
                if (index + 1 < part.length()) {
                    end = Long.parseLong(part.substring(index + 1));
                    if (end < start) {
                        UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", rangeHeader);
                        return null;
                    }
                } else {
                    end = -1L;
                }
                ranges.add(new Range(start, end));
            }
            catch (NumberFormatException e) {
                UndertowLogger.REQUEST_LOGGER.debugf("Invalid range spec %s", rangeHeader);
                return null;
            }
        }
        if (ranges.isEmpty()) {
            return null;
        }
        return new ByteRange(ranges);
    }

    public static class Range {
        private final long start;
        private final long end;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

