/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.extensions.ExtensionHandshake;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.http.ExtendedHandshakeChecker;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

public class WebSocketClient {
    public static final String BIND_PROPERTY = "io.undertow.websockets.BIND_ADDRESS";

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, null, bufferPool, optionMap, uri, version, clientNegotiation);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, clientNegotiation, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, null, uri, version, clientNegotiation, clientExtensions);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, InetSocketAddress bindAddress, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connectionBuilder(worker, bufferPool, uri).setSsl(ssl).setOptionMap(optionMap).setBindAddress(bindAddress).setVersion(version).setClientNegotiation(clientNegotiation).setClientExtensions(clientExtensions).connect();
    }

    public static ConnectionBuilder connectionBuilder(XnioWorker worker, ByteBufferPool bufferPool, URI uri) {
        return new ConnectionBuilder(worker, bufferPool, uri);
    }

    private WebSocketClient() {
    }

    public static class ConnectionBuilder {
        private final XnioWorker worker;
        private final ByteBufferPool bufferPool;
        private final URI uri;
        private XnioSsl ssl;
        private OptionMap optionMap = OptionMap.EMPTY;
        private InetSocketAddress bindAddress;
        private WebSocketVersion version = WebSocketVersion.V13;
        private WebSocketClientNegotiation clientNegotiation;
        private Set<ExtensionHandshake> clientExtensions;
        private URI proxyUri;
        private XnioSsl proxySsl;

        public ConnectionBuilder(XnioWorker worker, ByteBufferPool bufferPool, URI uri) {
            this.worker = worker;
            this.bufferPool = bufferPool;
            this.uri = uri;
        }

        public XnioWorker getWorker() {
            return this.worker;
        }

        public URI getUri() {
            return this.uri;
        }

        public XnioSsl getSsl() {
            return this.ssl;
        }

        public ConnectionBuilder setSsl(XnioSsl ssl) {
            this.ssl = ssl;
            return this;
        }

        public ByteBufferPool getBufferPool() {
            return this.bufferPool;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public ConnectionBuilder setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
            return this;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public ConnectionBuilder setBindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public WebSocketVersion getVersion() {
            return this.version;
        }

        public ConnectionBuilder setVersion(WebSocketVersion version) {
            this.version = version;
            return this;
        }

        public WebSocketClientNegotiation getClientNegotiation() {
            return this.clientNegotiation;
        }

        public ConnectionBuilder setClientNegotiation(WebSocketClientNegotiation clientNegotiation) {
            this.clientNegotiation = clientNegotiation;
            return this;
        }

        public Set<ExtensionHandshake> getClientExtensions() {
            return this.clientExtensions;
        }

        public ConnectionBuilder setClientExtensions(Set<ExtensionHandshake> clientExtensions) {
            this.clientExtensions = clientExtensions;
            return this;
        }

        public URI getProxyUri() {
            return this.proxyUri;
        }

        public ConnectionBuilder setProxyUri(URI proxyUri) {
            this.proxyUri = proxyUri;
            return this;
        }

        public XnioSsl getProxySsl() {
            return this.proxySsl;
        }

        public ConnectionBuilder setProxySsl(XnioSsl proxySsl) {
            this.proxySsl = proxySsl;
            return this;
        }

        public IoFuture<WebSocketChannel> connect() {
            URI newUri;
            final FutureResult ioFuture = new FutureResult();
            String scheme = this.uri.getScheme().equals("wss") ? "https" : "http";
            try {
                newUri = new URI(scheme, this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort() == -1 ? (this.uri.getScheme().equals("wss") ? 443 : 80) : this.uri.getPort(), this.uri.getPath().isEmpty() ? "/" : this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            final WebSocketClientHandshake handshake = WebSocketClientHandshake.create(this.version, newUri, this.clientNegotiation, this.clientExtensions);
            Map<String, String> originalHeaders = handshake.createHeaders();
            originalHeaders.put("Origin", scheme + "://" + this.uri.getHost());
            final HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : originalHeaders.entrySet()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getValue());
                headers.put(entry.getKey(), list);
            }
            if (this.clientNegotiation != null) {
                this.clientNegotiation.beforeRequest(headers);
            }
            InetSocketAddress toBind = this.bindAddress;
            String sysBind = System.getProperty(WebSocketClient.BIND_PROPERTY);
            if (toBind == null && sysBind != null) {
                toBind = new InetSocketAddress(sysBind, 0);
            }
            InetSocketAddress finalToBind = toBind;
            if (this.proxyUri != null) {
                UndertowClient.getInstance().connect(new ClientCallback<ClientConnection>(){

                    @Override
                    public void completed(final ClientConnection connection) {
                        int port = ConnectionBuilder.this.uri.getPort() > 0 ? ConnectionBuilder.this.uri.getPort() : (ConnectionBuilder.this.uri.getScheme().equals("https") || ConnectionBuilder.this.uri.getScheme().equals("wss") ? 443 : 80);
                        ClientRequest cr = new ClientRequest().setMethod(Methods.CONNECT).setPath(ConnectionBuilder.this.uri.getHost() + ":" + port).setProtocol(Protocols.HTTP_1_1);
                        connection.sendRequest(cr, new ClientCallback<ClientExchange>(){

                            @Override
                            public void completed(ClientExchange result) {
                                result.setResponseListener(new ClientCallback<ClientExchange>(){

                                    @Override
                                    public void completed(ClientExchange response) {
                                        block6: {
                                            if (response.getResponse().getResponseCode() == 200) {
                                                try {
                                                    StreamConnection targetConnection = connection.performUpgrade();
                                                    if (ConnectionBuilder.this.uri.getScheme().equals("wss") || ConnectionBuilder.this.uri.getScheme().equals("https")) {
                                                        this.handleConnectionWithExistingConnection((StreamConnection)((UndertowXnioSsl)ConnectionBuilder.this.ssl).wrapExistingConnection(targetConnection, ConnectionBuilder.this.optionMap));
                                                        break block6;
                                                    }
                                                    this.handleConnectionWithExistingConnection(targetConnection);
                                                }
                                                catch (IOException e) {
                                                    ioFuture.setException(e);
                                                }
                                                catch (Exception e) {
                                                    ioFuture.setException(new IOException(e));
                                                }
                                            } else {
                                                ioFuture.setException(UndertowMessages.MESSAGES.proxyConnectionFailed(response.getResponse().getResponseCode()));
                                            }
                                        }
                                    }

                                    private void handleConnectionWithExistingConnection(StreamConnection targetConnection) {
                                        final IoFuture result = HttpUpgrade.performUpgrade((StreamConnection)targetConnection, (URI)newUri, (Map)headers, (ChannelListener)new WebsocketConnectionListener(ConnectionBuilder.this.optionMap, handshake, newUri, (FutureResult<WebSocketChannel>)ioFuture), (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers));
                                        result.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<Object, Object>(){

                                            public void notify(IoFuture<?> res, Object attachment) {
                                                if (res.getStatus() == IoFuture.Status.FAILED) {
                                                    ioFuture.setException(res.getException());
                                                }
                                            }
                                        }, null);
                                        ioFuture.addCancelHandler(new Cancellable(){

                                            public Cancellable cancel() {
                                                result.cancel();
                                                return null;
                                            }
                                        });
                                    }

                                    @Override
                                    public void failed(IOException e) {
                                        ioFuture.setException(e);
                                    }
                                });
                            }

                            @Override
                            public void failed(IOException e) {
                                ioFuture.setException(e);
                            }
                        });
                    }

                    @Override
                    public void failed(IOException e) {
                        ioFuture.setException(e);
                    }
                }, this.bindAddress, this.proxyUri, this.worker, this.proxySsl, this.bufferPool, this.optionMap);
            } else {
                final IoFuture result = this.ssl != null ? HttpUpgrade.performUpgrade((XnioWorker)this.worker, (XnioSsl)this.ssl, (InetSocketAddress)toBind, (URI)newUri, headers, (ChannelListener)new WebsocketConnectionListener(this.optionMap, handshake, newUri, (FutureResult<WebSocketChannel>)ioFuture), null, (OptionMap)this.optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers)) : HttpUpgrade.performUpgrade((XnioWorker)this.worker, (InetSocketAddress)toBind, (URI)newUri, headers, (ChannelListener)new WebsocketConnectionListener(this.optionMap, handshake, newUri, (FutureResult<WebSocketChannel>)ioFuture), null, (OptionMap)this.optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers));
                result.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<Object, Object>(){

                    public void notify(IoFuture<?> res, Object attachment) {
                        if (res.getStatus() == IoFuture.Status.FAILED) {
                            ioFuture.setException(res.getException());
                        }
                    }
                }, null);
                ioFuture.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        result.cancel();
                        return null;
                    }
                });
            }
            return ioFuture.getIoFuture();
        }

        private class WebsocketConnectionListener
        implements ChannelListener<StreamConnection> {
            private final OptionMap options;
            private final WebSocketClientHandshake handshake;
            private final URI newUri;
            private final FutureResult<WebSocketChannel> ioFuture;

            WebsocketConnectionListener(OptionMap options, WebSocketClientHandshake handshake, URI newUri, FutureResult<WebSocketChannel> ioFuture) {
                this.options = options;
                this.handshake = handshake;
                this.newUri = newUri;
                this.ioFuture = ioFuture;
            }

            public void handleEvent(StreamConnection channel) {
                WebSocketChannel result = this.handshake.createChannel(channel, this.newUri.toString(), ConnectionBuilder.this.bufferPool, this.options);
                this.ioFuture.setResult((Object)result);
            }
        }
    }
}

