/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DelegatingStreamSinkChannel<T extends DelegatingStreamSinkChannel>
implements StreamSinkChannel {
    protected final StreamSinkChannel delegate;
    protected final ChannelListener.SimpleSetter<T> writeSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<T> closeSetter = new ChannelListener.SimpleSetter();

    public DelegatingStreamSinkChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.delegate.transferFrom(src, position, count);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public boolean isWriteResumed() {
        return this.delegate.isWriteResumed();
    }

    public boolean flush() throws IOException {
        return this.delegate.flush();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.delegate.setOption(option, value);
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public final long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public void resumeWrites() {
        this.delegate.resumeWrites();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void shutdownWrites() throws IOException {
        this.delegate.shutdownWrites();
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public void wakeupWrites() {
        this.delegate.wakeupWrites();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.delegate.getOption(option);
    }

    public void suspendWrites() {
        this.delegate.suspendWrites();
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return this.delegate.writeFinal(src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.writeFinal(srcs, offset, length);
    }

    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.delegate.writeFinal(srcs);
    }
}

