/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class InflatingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    public static final ConduitWrapper<StreamSourceConduit> WRAPPER = new ConduitWrapper<StreamSourceConduit>(){

        @Override
        public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
            return new InflatingStreamSourceConduit(exchange, factory.create());
        }
    };
    private final HttpServerExchange exchange;
    private final Inflater inflater = new Inflater(true);
    private PooledByteBuffer compressed;
    private PooledByteBuffer uncompressed;
    private boolean nextDone = false;
    private boolean headerDone = false;

    public InflatingStreamSourceConduit(HttpServerExchange exchange, StreamSourceConduit next) {
        super(next);
        this.exchange = exchange;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.isReadShutdown()) {
            throw new ClosedChannelException();
        }
        if (this.uncompressed != null) {
            int ret = Buffers.copy((ByteBuffer)dst, (ByteBuffer)this.uncompressed.getBuffer());
            if (!this.uncompressed.getBuffer().hasRemaining()) {
                this.uncompressed.close();
                this.uncompressed = null;
            }
            return ret;
        }
        if (this.compressed == null && !this.nextDone) {
            this.compressed = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();
            ByteBuffer buf = this.compressed.getBuffer();
            int res = ((StreamSourceConduit)this.next).read(buf);
            if (res == -1) {
                this.nextDone = true;
                this.compressed.close();
                this.compressed = null;
            } else {
                if (res == 0) {
                    this.compressed.close();
                    this.compressed = null;
                    return 0;
                }
                buf.flip();
                if (!this.headerDone) {
                    this.headerDone = this.readHeader(buf);
                }
                this.inflater.setInput(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            }
        }
        if (this.nextDone && this.inflater.needsInput() && !this.inflater.finished()) {
            throw UndertowLogger.ROOT_LOGGER.unexpectedEndOfCompressedInput();
        }
        if (this.nextDone && this.inflater.finished()) {
            this.done();
            return -1;
        }
        if (this.inflater.finished()) {
            int res;
            int rem = this.inflater.getRemaining();
            ByteBuffer buf = this.compressed.getBuffer();
            buf.position(buf.limit() - rem);
            this.readFooter(buf);
            do {
                buf.clear();
                res = ((StreamSourceConduit)this.next).read(buf);
                buf.flip();
                if (res == -1) {
                    this.done();
                    this.nextDone = true;
                    return -1;
                }
                if (res <= 0) continue;
                this.readFooter(buf);
            } while (res != 0);
            this.compressed.close();
            this.compressed = null;
            return 0;
        }
        if (this.compressed == null) {
            throw new RuntimeException();
        }
        this.uncompressed = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();
        try {
            int read = this.inflater.inflate(this.uncompressed.getBuffer().array(), this.uncompressed.getBuffer().arrayOffset(), this.uncompressed.getBuffer().limit());
            this.uncompressed.getBuffer().limit(read);
            this.dataDeflated(this.uncompressed.getBuffer().array(), this.uncompressed.getBuffer().arrayOffset(), read);
            if (this.inflater.needsInput()) {
                this.compressed.close();
                this.compressed = null;
            }
            int ret = Buffers.copy((ByteBuffer)dst, (ByteBuffer)this.uncompressed.getBuffer());
            if (!this.uncompressed.getBuffer().hasRemaining()) {
                this.uncompressed.close();
                this.uncompressed = null;
            }
            return ret;
        }
        catch (DataFormatException e) {
            this.done();
            throw new IOException(e);
        }
    }

    protected void readFooter(ByteBuffer buf) throws IOException {
    }

    protected boolean readHeader(ByteBuffer byteBuffer) throws IOException {
        return true;
    }

    protected void dataDeflated(byte[] data, int off, int len) {
    }

    private void done() {
        if (this.compressed != null) {
            this.compressed.close();
        }
        if (this.uncompressed != null) {
            this.uncompressed.close();
        }
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        try {
            return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
        }
        catch (IOException | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            throw e;
        }
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        try {
            return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
        }
        catch (IOException | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            throw e;
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public void terminateReads() throws IOException {
        this.done();
        ((StreamSourceConduit)this.next).terminateReads();
    }
}

