package io.undertow.client;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.lang.String;
import java.io.IOException;
import java.util.Arrays;
import java.net.URI;
import java.lang.IllegalArgumentException;
import io.undertow.util.HttpString;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2023-03-26T11:39:15-0300")
public class UndertowClientMessages_$bundle implements UndertowClientMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected UndertowClientMessages_$bundle() {}
    public static final UndertowClientMessages_$bundle INSTANCE = new UndertowClientMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String connectionClosed$str() {
        return "UT001000: Connection closed";
    }
    @Override
    public final String connectionClosed() {
        return String.format(getLoggingLocale(), connectionClosed$str());
    }
    protected String requestAlreadyWritten$str() {
        return "UT001001: Request already written";
    }
    @Override
    public final IllegalStateException requestAlreadyWritten() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requestAlreadyWritten$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String failedToUpgradeChannel$str() {
        return "UT001020: Failed to upgrade channel due to response %s (%s)";
    }
    @Override
    public final String failedToUpgradeChannel(final int responseCode, final String reason) {
        return String.format(getLoggingLocale(), failedToUpgradeChannel$str(), responseCode, reason);
    }
    protected String illegalContentLength$str() {
        return "UT001030: invalid content length %d";
    }
    @Override
    public final IllegalArgumentException illegalContentLength(final long length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalContentLength$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownScheme$str() {
        return "UT001031: Unknown scheme in URI %s";
    }
    @Override
    public final IllegalArgumentException unknownScheme(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownScheme$str(), uri));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTransferEncoding$str() {
        return "UT001032: Unknown transfer encoding %s";
    }
    @Override
    public final IOException unknownTransferEncoding(final String transferEncodingString) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unknownTransferEncoding$str(), transferEncodingString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConnectionState$str() {
        return "UT001033: Invalid connection state";
    }
    @Override
    public final IOException invalidConnectionState() {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidConnectionState$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAjpMessageType$str() {
        return "UT001034: Unknown AJP packet type %s";
    }
    @Override
    public final IOException unknownAjpMessageType(final byte packetType) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unknownAjpMessageType$str(), packetType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownMethod$str() {
        return "UT001035: Unknown method type for AJP request %s";
    }
    @Override
    public final IOException unknownMethod(final HttpString method) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unknownMethod$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dataStillRemainingInChunk$str() {
        return "UT001036: Data still remaining in chunk %s";
    }
    @Override
    public final IOException dataStillRemainingInChunk(final long remaining) {
        final IOException result = new IOException(String.format(getLoggingLocale(), dataStillRemainingInChunk$str(), remaining));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongMagicNumber$str() {
        return "UT001037: Wrong magic number, expected %s, actual %s";
    }
    @Override
    public final IOException wrongMagicNumber(final String expected, final String actual) {
        final IOException result = new IOException(String.format(getLoggingLocale(), wrongMagicNumber$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String receivedInvalidChunk$str() {
        return "UT001038: Received invalid AJP chunk %s with response already complete";
    }
    @Override
    public final IOException receivedInvalidChunk(final byte prefix) {
        final IOException result = new IOException(String.format(getLoggingLocale(), receivedInvalidChunk$str(), prefix));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
