/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class H2CUpgradeResetTestCase {
    private static final String ECHO_PATH = "/echo";
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static XnioWorker worker;
    private static Undertow server;

    private static void sendEchoResponse(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        if (exchange.getRequestContentLength() > 0L) {
            exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                public void handle(HttpServerExchange exchange, String message) {
                    exchange.getResponseSender().send(message);
                }
            });
        } else {
            Sender sender = exchange.getResponseSender();
            sender.send("");
        }
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        PathHandler path = new PathHandler().addExactPath(ECHO_PATH, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                H2CUpgradeResetTestCase.sendEchoResponse(exchange);
            }
        });
        server = Undertow.builder().addHttpListener(DefaultServer.getHostPort() + 1, DefaultServer.getHostAddress(), (HttpHandler)new Http2UpgradeHandler((HttpHandler)path)).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).build();
        server.start();
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).getMap());
    }

    @AfterClass
    public static void afterClass() {
        if (server != null) {
            server.stop();
        }
        if (worker != null) {
            worker.shutdown();
        }
    }

    private void sendRequest(final ClientConnection connection, final int contentLength, final boolean reset) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < contentLength; ++i) {
            sb.append(i % 10);
        }
        final String content = sb.length() > 0 ? sb.toString() : null;
        connection.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(H2CUpgradeResetTestCase.ECHO_PATH);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                request.getRequestHeaders().put(Headers.CONTENT_LENGTH, (long)contentLength);
                connection.sendRequest(request, H2CUpgradeResetTestCase.createClientCallback(responses, latch, content, reset));
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"No response received from server in 10s", (long)1L, (long)responses.size());
        Assert.assertEquals((String)"Response code was not OK", (long)200L, (long)((ClientResponse)responses.get(0)).getResponseCode());
        Assert.assertEquals((String)"Incorrect data received for response", (Object)(contentLength > 0 ? content : ""), (Object)((ClientResponse)responses.get(0)).getAttachment(RESPONSE_BODY));
    }

    @Test
    public void testUpgradeWithReset() throws Exception {
        UndertowClient client = UndertowClient.getInstance();
        ClientConnection connection = (ClientConnection)client.connect(new URI("http://" + DefaultServer.getHostAddress() + ":" + (DefaultServer.getHostPort() + 1)), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            this.sendRequest(connection, 10, true);
            this.sendRequest(connection, 10, false);
            this.sendRequest(connection, 10, true);
            this.sendRequest(connection, 10, false);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private static ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch, final String message, final boolean reset) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                if (message != null) {
                    new StringWriteChannelListener(message).setup(result.getRequestChannel());
                }
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                if (reset) {
                                    Http2StreamSourceChannel res = (Http2StreamSourceChannel)result.getResponseChannel();
                                    res.getHttp2Channel().sendRstStream(res.getStreamId(), 5);
                                }
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }
}

