/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class ParseTimeoutTestCase {
    private Socket client;
    private OutputStream clientOutputStream;
    private InputStream clientInputStream;

    @Before
    public void before() throws Exception {
        this.client = new Socket();
        this.client.connect(DefaultServer.getDefaultServerAddress());
        this.clientOutputStream = this.client.getOutputStream();
        this.clientInputStream = this.client.getInputStream();
    }

    @After
    public void after() throws Exception {
        IoUtils.safeClose((Socket)this.client);
        DefaultServer.setUndertowOptions(OptionMap.EMPTY);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.REQUEST_PARSE_TIMEOUT, (Object)10));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        DefaultServer.setUndertowOptions(OptionMap.EMPTY);
    }

    @Test(timeout=10000L)
    public void testClosingConnectionWhenParsingHeadersForTooLong() throws Exception {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                Assert.fail((String)"Parser should never end its job, since we are streaming headers.");
            }
        });
        String request = "GET / HTTP/1.1\r\nHost:localhost";
        this.clientOutputStream.write(request.getBytes());
        this.clientOutputStream.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)-1L, (long)this.clientInputStream.read());
    }
}

