/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RequestStatistics;
import io.undertow.server.handlers.ActiveRequestTrackerHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ActiveRequestTrackerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTracking() throws InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            ActiveRequestTrackerHandler handler = new ActiveRequestTrackerHandler((HttpHandler)new DelayHandler(latch), null);
            DefaultServer.setRootHandler((HttpHandler)handler);
            Thread t = new Thread(() -> this.makeRequest(client));
            t.start();
            List trackedRequests = handler.getTrackedRequests();
            try {
                while (trackedRequests.isEmpty() && t.isAlive()) {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    trackedRequests = handler.getTrackedRequests();
                }
            }
            finally {
                latch.countDown();
            }
            Assert.assertEquals((String)"Expecting 1 tracked request", (long)1L, (long)trackedRequests.size());
            RequestStatistics request = (RequestStatistics)trackedRequests.get(0);
            Assert.assertNotNull((Object)request.getUri());
            Assert.assertNotNull((Object)request.getMethod());
            Assert.assertNotNull((Object)request.getProtocol());
            Assert.assertNotNull((Object)request.getQueryString());
            Assert.assertNotNull((Object)request.getRemoteAddress());
            Assert.assertNotSame((Object)0, (Object)request.getBytesReceived());
            Assert.assertNotSame((Object)0, (Object)request.getBytesSent());
            Assert.assertNotSame((Object)0, (Object)request.getStartTime());
            Assert.assertNotSame((Object)0, (Object)request.getProcessingTime());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void makeRequest(TestHttpClient client) {
        try {
            client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class DelayHandler
    implements HttpHandler {
        private final CountDownLatch latch;

        DelayHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
    }
}

