/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.BlockingWriteTimeoutHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.channels.WriteTimeoutException;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
@ProxyIgnore
public class BlockingWriteTimeoutHandlerTestCase {
    private volatile Exception exception;
    private static final CountDownLatch errorLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteTimeout() throws InterruptedException {
        block9: {
            DefaultServer.setRootHandler(BlockingWriteTimeoutHandler.builder().nextHandler((HttpHandler)new BlockingHandler(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    int i;
                    int capacity = 0x100000;
                    byte[] data = new byte[0x100000];
                    for (i = 0; i < 0x100000; ++i) {
                        data[i] = 42;
                    }
                    try {
                        for (i = 0; i < 20; ++i) {
                            exchange.getOutputStream().write(data);
                        }
                    }
                    catch (IOException e) {
                        BlockingWriteTimeoutHandlerTestCase.this.exception = e;
                        errorLatch.countDown();
                    }
                }
            })).writeTimeout(Duration.ofMillis(1L)).build());
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertFalse((String)"The result entity is buffered", (boolean)result.getEntity().isRepeatable());
                InputStream content = result.getEntity().getContent();
                byte[] buffer = new byte[512];
                int r = 0;
                while ((r = content.read(buffer)) > 0) {
                    Thread.sleep(200L);
                    if (this.exception == null) continue;
                    Assert.assertEquals(WriteTimeoutException.class, this.exception.getClass());
                    return;
                }
                try {
                    Assert.fail((String)"Write did not time out");
                }
                catch (IOException e) {
                    if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                        Assert.assertEquals(WriteTimeoutException.class, this.exception.getClass());
                        break block9;
                    }
                    Assert.fail((String)"Write did not time out");
                }
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }
}

