/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xnio.Options;
import org.xnio.XnioWorker;

public class LoadBalancingProxyWithHeaderTableSizeSettingsTestCase {
    private Undertow server;
    private Undertow loadBalancer;

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.server = this.startHttpServer();
        this.loadBalancer = this.startLoadBalancer();
        this.server.start();
        this.loadBalancer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        XnioWorker worker;
        XnioWorker worker1 = null;
        XnioWorker worker2 = null;
        int countDown = 0;
        try {
            if (this.loadBalancer != null) {
                worker = this.loadBalancer.getWorker();
                this.loadBalancer.stop();
                if (worker != null && !worker.isShutdown()) {
                    ++countDown;
                    worker1 = worker;
                }
            }
        }
        finally {
            block24: {
                CountDownLatch latch;
                block25: {
                    try {
                        if (this.server != null) {
                            worker = this.server.getWorker();
                            this.server.stop();
                            if (worker != null && !worker.isShutdown() && worker != worker1) {
                                worker2 = worker;
                                ++countDown;
                            }
                        }
                        if (countDown == 0) break block24;
                        latch = new CountDownLatch(countDown);
                        if (worker1 == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (countDown != 0) {
                            CountDownLatch latch2 = new CountDownLatch(countDown);
                            if (worker1 != null) {
                                worker1.getIoThread().execute(latch2::countDown);
                            }
                            if (worker2 != null) {
                                worker2.getIoThread().execute(latch2::countDown);
                            }
                            try {
                                latch2.await();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        throw throwable;
                    }
                    worker1.getIoThread().execute(latch::countDown);
                }
                if (worker2 != null) {
                    worker2.getIoThread().execute(latch::countDown);
                }
                try {
                    latch.await();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private Undertow startHttpServer() {
        return Undertow.builder().addHttpListener(8001, DefaultServer.isIpv6() ? "::1" : "127.0.0.1").setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setHandler(exchange -> {
            exchange.setStatusCode(200);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
            exchange.getResponseSender().send("Hello, world!");
        }).build();
    }

    private Undertow startLoadBalancer() {
        int workerThreads = Runtime.getRuntime().availableProcessors() * 8;
        LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(20).addHost(URI.create("http://localhost:8001/"));
        ProxyHandler proxyHandler = ProxyHandler.builder().setReuseXForwarded(false).setRewriteHostHeader(false).setMaxRequestTime(30000).setProxyClient((ProxyClient)loadBalancer).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).build();
        return Undertow.builder().setIoThreads(4).setWorkerThreads(workerThreads).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setWorkerOption(Options.WORKER_TASK_MAX_THREADS, (Object)workerThreads).setSocketOption(Options.BACKLOG, (Object)1000).setHandler((HttpHandler)proxyHandler).addHttpListener(8000, "0.0.0.0").build();
    }

    @Test
    public void sendRequest() throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:8000")).GET().build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)200L, (long)response.statusCode());
        Assert.assertEquals((Object)"Hello, world!", (Object)response.body());
    }
}

