/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.predicate.PredicatesHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class ModClusterTestSetup {
    static String chost = System.getProperty("io.undertow.examples.proxy.CADDRESS", "localhost");
    static final int cport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.CPORT", "6666"));
    static String phost = System.getProperty("io.undertow.examples.proxy.ADDRESS", "localhost");
    static final int pport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.PORT", "8000"));

    public static void main(String[] args) throws IOException {
        XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
        final ModCluster modCluster = ModCluster.builder((XnioWorker)worker).setHealthCheckInterval(TimeUnit.SECONDS.toMillis(3L)).setRemoveBrokenNodes(TimeUnit.SECONDS.toMillis(30L)).build();
        try {
            if (chost == null) {
                chost = InetAddress.getLocalHost().getHostName();
                System.out.println("Using: " + chost + ":" + cport);
            }
            modCluster.start();
            HttpHandler proxy = modCluster.createProxyHandler();
            MCMPConfig config = MCMPConfig.builder().setManagementHost(chost).setManagementPort(cport).enableAdvertise().setSecurityKey("secret").getParent().build();
            MCMPConfig webConfig = MCMPConfig.webBuilder().setManagementHost(chost).setManagementPort(cport).build();
            PredicatesHandler root = Handlers.predicates((List)PredicatedHandlersParser.parse((String)"regex[pattern='cluster.domain.com', value='%{i,Host}'] and equals[%R, '/'] -> rewrite['/myapp/MyCount']\nregex[pattern='cluster.domain.org', value='%{i,Host}'] and regex['/(.*)'] -> rewrite['/myapp/${1}']\nregex[pattern='cluster.domain.net', value='%{i,Host}'] and regex['/test/(.*)'] -> rewrite['/myapp/${1}']\nregex[pattern='cluster.domain.info', value='%{i,Host}'] and path-template['/{one}/{two}'] -> rewrite['/test/${two}?partnerpath=/${one}&%q']\n", (ClassLoader)ModClusterTestSetup.class.getClassLoader()), (HttpHandler)proxy);
            HttpHandler mcmp = config.create(modCluster, (HttpHandler)root);
            HttpHandler web = webConfig.create(modCluster, (HttpHandler)ResponseCodeHandler.HANDLE_404);
            final Undertow server = Undertow.builder().addHttpListener(cport, chost).addHttpListener(pport, phost).setHandler((HttpHandler)Handlers.path((HttpHandler)mcmp).addPrefixPath("/mod_cluster_manager", web)).build();
            server.start();
            modCluster.advertise(config);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    modCluster.stop();
                    server.stop();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(r));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

