/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class InMemorySessionTestCase {
    public static final String COUNT = "count";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inMemorySessionTest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            final SessionCookieConfig sessionConfig = new SessionCookieConfig();
            SessionAttachmentHandler handler = new SessionAttachmentHandler((SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig);
            handler.setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                    Session session = manager.getSession(exchange, (SessionConfig)sessionConfig);
                    if (session == null) {
                        session = manager.createSession(exchange, (SessionConfig)sessionConfig);
                        session.setAttribute(InMemorySessionTestCase.COUNT, (Object)0);
                    }
                    Integer count = (Integer)session.getAttribute(InMemorySessionTestCase.COUNT);
                    exchange.getResponseHeaders().add(new HttpString(InMemorySessionTestCase.COUNT), count.toString());
                    count = count + 1;
                    session.setAttribute(InMemorySessionTestCase.COUNT, (Object)count);
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inMemoryMaxSessionsTest() throws IOException {
        TestHttpClient client1 = new TestHttpClient();
        client1.setCookieStore((CookieStore)new BasicCookieStore());
        TestHttpClient client2 = new TestHttpClient();
        client2.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            final SessionCookieConfig sessionConfig = new SessionCookieConfig();
            SessionAttachmentHandler handler = new SessionAttachmentHandler((SessionManager)new InMemorySessionManager("", 1, true), (SessionConfig)sessionConfig);
            handler.setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                    Session session = manager.getSession(exchange, (SessionConfig)sessionConfig);
                    if (session == null) {
                        session = manager.createSession(exchange, (SessionConfig)sessionConfig);
                        session.setAttribute(InMemorySessionTestCase.COUNT, (Object)0);
                    }
                    Integer count = (Integer)session.getAttribute(InMemorySessionTestCase.COUNT);
                    exchange.getResponseHeaders().add(new HttpString(InMemorySessionTestCase.COUNT), count.toString());
                    count = count + 1;
                    session.setAttribute(InMemorySessionTestCase.COUNT, (Object)count);
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            CloseableHttpResponse result = client1.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client1.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client2.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client1.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
        }
        finally {
            client1.getConnectionManager().shutdown();
            client2.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inMemorySessionTimeoutExpirationTest() throws IOException, InterruptedException {
        boolean maxInactiveIntervalInSeconds = true;
        int accessorThreadSleepInMilliseconds = 200;
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            final SessionCookieConfig sessionConfig = new SessionCookieConfig();
            SessionAttachmentHandler handler = new SessionAttachmentHandler((SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig);
            handler.setNext(new HttpHandler(){

                public void handleRequest(final HttpServerExchange exchange) throws Exception {
                    final SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                    Session session = manager.getSession(exchange, (SessionConfig)sessionConfig);
                    if (session == null) {
                        manager.setDefaultSessionTimeout(1);
                        session = manager.createSession(exchange, (SessionConfig)sessionConfig);
                        session.setAttribute(InMemorySessionTestCase.COUNT, (Object)0);
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                Session innerThreadSession = manager.getSession(exchange, (SessionConfig)sessionConfig);
                                int iterations = 5;
                                for (int i = 0; i <= iterations; ++i) {
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException e) {
                                        System.out.println(String.format("Unexpected error during Thread.sleep(): %s", e.getMessage()));
                                    }
                                    if (innerThreadSession == null) continue;
                                    try {
                                        System.out.println(String.format("Session is still valid. Attribute is: %s", innerThreadSession.getAttribute(InMemorySessionTestCase.COUNT).toString()));
                                        if (i != iterations) continue;
                                        System.out.println("Session should not still be valid!");
                                        continue;
                                    }
                                    catch (IllegalStateException e) {
                                        if (e instanceof IllegalStateException && e.getMessage().startsWith("UT000010")) {
                                            System.out.println(String.format("This is expected as session is not valid anymore: %s", e.getMessage()));
                                            continue;
                                        }
                                        System.out.println(String.format("Unexpected exception while calling session.getAttribute(): %s", e.getMessage()));
                                    }
                                }
                            }
                        };
                        Thread thread = new Thread(r);
                        thread.start();
                    }
                    Integer count = (Integer)session.getAttribute(InMemorySessionTestCase.COUNT);
                    exchange.getResponseHeaders().add(new HttpString(InMemorySessionTestCase.COUNT), count.toString());
                    count = count + 1;
                    session.setAttribute(InMemorySessionTestCase.COUNT, (Object)count);
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            Thread.sleep(2000L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

