/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleConfidentialRedirectTestCase {
    private static int redirectPort = -1;

    @BeforeClass
    public static void setup() throws IOException {
        DefaultServer.startSSLServer();
        HttpHandler current = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"uri"), exchange.getRequestURI());
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"queryString"), exchange.getQueryString());
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"redirectedToPort"), (long)exchange.getHostPort());
                exchange.endExchange();
            }
        };
        redirectPort = DefaultServer.getHostSSLPort("default");
        current = new SinglePortConfidentialityHandler(current, redirectPort);
        DefaultServer.setRootHandler(current);
    }

    @AfterClass
    public static void stop() throws IOException {
        DefaultServer.stopSSLServer();
    }

    @Test
    public void simpleRedirectTestCase() throws IOException, GeneralSecurityException {
        TestHttpClient client = new TestHttpClient();
        BasicHttpContext httpContext = new BasicHttpContext(){
            private final RequestConfig config = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setNormalizeUri(false).build();

            public void setAttribute(String id, Object obj) {
                if ("http.request-config".equals(id)) {
                    return;
                }
                super.setAttribute(id, obj);
            }

            public Object getAttribute(String id) {
                if ("http.request-config".equals(id)) {
                    return this.config;
                }
                return super.getAttribute(id);
            }
        };
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            this.sendRequest(client, (HttpContext)httpContext, "/foo", null);
            this.sendRequest(client, (HttpContext)httpContext, "/foo+bar", null);
            this.sendRequest(client, (HttpContext)httpContext, "/foo+bar;aa", null);
            this.sendRequest(client, (HttpContext)httpContext, "/foo+bar;aa", "x=y");
            this.sendRequest(client, (HttpContext)httpContext, "/foo+bar%3Aaa", "x=%3Ablah");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @ProxyIgnore
    public void testRedirectWithFullURLInPath() throws IOException {
        DefaultServer.isProxy();
        try (Socket socket = new Socket(DefaultServer.getHostAddress(), DefaultServer.getHostPort());){
            socket.getOutputStream().write(("GET " + DefaultServer.getDefaultServerURL() + "/foo HTTP/1.0\r\n\r\n").getBytes(StandardCharsets.UTF_8));
            String result = FileUtils.readFile((InputStream)socket.getInputStream());
            Assert.assertTrue((boolean)result.contains("Location: " + DefaultServer.getDefaultServerSSLAddress() + "/foo"));
        }
    }

    private void sendRequest(TestHttpClient client, HttpContext httpContext, String uri, String queryString) throws IOException {
        String targetURL = DefaultServer.getDefaultServerURL() + uri;
        if (queryString != null) {
            targetURL = targetURL + "?" + queryString;
        }
        HttpGet get = new HttpGet(targetURL);
        CloseableHttpResponse result = client.execute((HttpUriRequest)get, httpContext);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Assert.assertEquals((String)"Unexpected scheme in redirected URI", (Object)"https", (Object)result.getFirstHeader("scheme").getValue());
        Assert.assertEquals((String)"Unexpected port in redirected URI", (Object)String.valueOf(redirectPort), (Object)result.getFirstHeader("redirectedToPort").getValue());
        Assert.assertEquals((String)"Unexpected path in redirected URI", (Object)uri, (Object)result.getFirstHeader("uri").getValue());
        if (queryString != null) {
            Assert.assertEquals((String)"Unexpected query string in redirected URI", (Object)queryString, (Object)result.getFirstHeader("queryString").getValue());
        }
        HttpClientUtils.readResponse((HttpResponse)result);
    }
}

