/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.testutils.category.UnitTest;
import io.undertow.websockets.WebSocketExtension;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class WebSocketExtensionParserTest {
    @Test
    public void testParseExtension() {
        String EXTENSION_HEADER1 = " x-webkit-deflate-message , x-custom-extension ";
        List extensions1 = WebSocketExtension.parse((String)" x-webkit-deflate-message , x-custom-extension ");
        Assert.assertEquals((long)2L, (long)extensions1.size());
        Assert.assertEquals((Object)"x-webkit-deflate-message", (Object)((WebSocketExtension)extensions1.get(0)).getName());
        Assert.assertEquals((Object)"x-custom-extension", (Object)((WebSocketExtension)extensions1.get(1)).getName());
        String EXTENSION_HEADER2 = " foo, bar; baz=2";
        List extensions2 = WebSocketExtension.parse((String)" foo, bar; baz=2");
        Assert.assertEquals((long)2L, (long)extensions2.size());
        Assert.assertEquals((Object)"foo", (Object)((WebSocketExtension)extensions2.get(0)).getName());
        Assert.assertEquals((long)0L, (long)((WebSocketExtension)extensions2.get(0)).getParameters().size());
        Assert.assertEquals((Object)"bar", (Object)((WebSocketExtension)extensions2.get(1)).getName());
        Assert.assertEquals((long)1L, (long)((WebSocketExtension)extensions2.get(1)).getParameters().size());
        Assert.assertEquals((Object)"baz", (Object)((WebSocketExtension.Parameter)((WebSocketExtension)extensions2.get(1)).getParameters().get(0)).getName());
        Assert.assertEquals((Object)"2", (Object)((WebSocketExtension.Parameter)((WebSocketExtension)extensions2.get(1)).getParameters().get(0)).getValue());
    }

    @Test
    public void testToExtensionHeader() {
        String EXTENSION_HEADER1 = " x-webkit-deflate-message , x-custom-extension ";
        List extensions1 = WebSocketExtension.parse((String)" x-webkit-deflate-message , x-custom-extension ");
        String extensionHeader1 = WebSocketExtension.toExtensionHeader((List)extensions1);
        Assert.assertEquals((Object)"x-webkit-deflate-message, x-custom-extension", (Object)extensionHeader1);
        String EXTENSION_HEADER2 = " foo, bar; baz=2";
        List extensions2 = WebSocketExtension.parse((String)" foo, bar; baz=2");
        String extensionHeader2 = WebSocketExtension.toExtensionHeader((List)extensions2);
        Assert.assertEquals((Object)"foo, bar; baz=2", (Object)extensionHeader2);
    }

    @Test
    public void testWriteRsvBits() {
        int rsv = 4;
        Assert.assertEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 2;
        Assert.assertEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 1;
        Assert.assertEquals((long)1L, (long)(rsv & 1));
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        rsv = 6;
        Assert.assertEquals((long)4L, (long)(rsv & 4));
        Assert.assertEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 3;
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertEquals((long)2L, (long)(rsv & 2));
        Assert.assertEquals((long)1L, (long)(rsv & 1));
        rsv = 5;
        Assert.assertEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        Assert.assertEquals((long)1L, (long)(rsv & 1));
        rsv = 7;
        Assert.assertEquals((long)4L, (long)(rsv & 4));
        Assert.assertEquals((long)2L, (long)(rsv & 2));
        Assert.assertEquals((long)1L, (long)(rsv & 1));
        rsv = 8;
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 4;
        Assert.assertEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 2;
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertEquals((long)2L, (long)(rsv & 2));
        Assert.assertNotEquals((long)1L, (long)(rsv & 1));
        rsv = 1;
        Assert.assertNotEquals((long)4L, (long)(rsv & 4));
        Assert.assertNotEquals((long)2L, (long)(rsv & 2));
        Assert.assertEquals((long)1L, (long)(rsv & 1));
    }
}

