/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HexConverter;
import jakarta.servlet.ServletRequest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class SSLInformationAssociationHandler
implements HttpHandler {
    private final HttpHandler next;

    public SSLInformationAssociationHandler(HttpHandler next) {
        this.next = next;
    }

    public static int getKeyLength(String cipherSuite) {
        return SSLSessionInfo.calculateKeySize(cipherSuite);
    }

    private X509Certificate[] getCerts(SSLSessionInfo session) {
        try {
            Certificate[] javaCerts = session.getPeerCertificates();
            if (javaCerts == null) {
                return null;
            }
            int x509Certs = 0;
            for (Certificate javaCert : javaCerts) {
                if (!(javaCert instanceof X509Certificate)) continue;
                ++x509Certs;
            }
            if (x509Certs == 0) {
                return null;
            }
            int resultIndex = 0;
            X509Certificate[] results = new X509Certificate[x509Certs];
            for (Certificate certificate : javaCerts) {
                if (!(certificate instanceof X509Certificate)) continue;
                results[resultIndex++] = (X509Certificate)certificate;
            }
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequest request = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getServletRequest();
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl != null) {
            String cipherSuite = ssl.getCipherSuite();
            byte[] sessionId = ssl.getSessionId();
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", ssl.getKeySize());
            request.setAttribute("javax.servlet.request.ssl_session_id", sessionId != null ? HexConverter.convertToHexString(sessionId) : null);
            X509Certificate[] certs = this.getCerts(ssl);
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
        }
        this.next.handleRequest(exchange);
    }
}

