/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.compat.rewrite;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.servlet.compat.rewrite.Resolver;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.DateUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Calendar;

public class UndertowResolver
extends Resolver {
    private final ServletRequestContext servletRequestContext;
    private final HttpServletRequest request;

    public UndertowResolver(ServletRequestContext servletRequestContext, HttpServletRequest request) {
        this.servletRequestContext = servletRequestContext;
        this.request = request;
    }

    @Override
    public String resolve(String key) {
        if (key.equals("HTTP_USER_AGENT")) {
            return this.request.getHeader("user-agent");
        }
        if (key.equals("HTTP_REFERER")) {
            return this.request.getHeader("referer");
        }
        if (key.equals("HTTP_COOKIE")) {
            return this.request.getHeader("cookie");
        }
        if (key.equals("HTTP_FORWARDED")) {
            return this.request.getHeader("forwarded");
        }
        if (key.equals("HTTP_HOST")) {
            int index;
            String host = this.request.getHeader("host");
            int n = index = host != null ? host.indexOf(58) : -1;
            if (index != -1) {
                host = host.substring(0, index);
            }
            return host;
        }
        if (key.equals("HTTP_PROXY_CONNECTION")) {
            return this.request.getHeader("proxy-connection");
        }
        if (key.equals("HTTP_ACCEPT")) {
            return this.request.getHeader("accept");
        }
        if (key.equals("REMOTE_ADDR")) {
            return this.request.getRemoteAddr();
        }
        if (key.equals("REMOTE_HOST")) {
            return this.request.getRemoteHost();
        }
        if (key.equals("REMOTE_PORT")) {
            return String.valueOf(this.request.getRemotePort());
        }
        if (key.equals("REMOTE_USER")) {
            return this.request.getRemoteUser();
        }
        if (key.equals("REMOTE_IDENT")) {
            return this.request.getRemoteUser();
        }
        if (key.equals("REQUEST_METHOD")) {
            return this.request.getMethod();
        }
        if (key.equals("SCRIPT_FILENAME")) {
            return this.request.getRealPath(this.request.getServletPath());
        }
        if (key.equals("REQUEST_PATH")) {
            return this.servletRequestContext.getExchange().getRelativePath();
        }
        if (key.equals("CONTEXT_PATH")) {
            return this.request.getContextPath();
        }
        if (key.equals("SERVLET_PATH")) {
            return UndertowResolver.emptyStringIfNull(this.request.getServletPath());
        }
        if (key.equals("PATH_INFO")) {
            return UndertowResolver.emptyStringIfNull(this.request.getPathInfo());
        }
        if (key.equals("QUERY_STRING")) {
            return UndertowResolver.emptyStringIfNull(this.request.getQueryString());
        }
        if (key.equals("AUTH_TYPE")) {
            return this.request.getAuthType();
        }
        if (key.equals("DOCUMENT_ROOT")) {
            return this.request.getRealPath("/");
        }
        if (key.equals("SERVER_NAME")) {
            return this.request.getLocalName();
        }
        if (key.equals("SERVER_ADDR")) {
            return this.request.getLocalAddr();
        }
        if (key.equals("SERVER_PORT")) {
            return String.valueOf(this.request.getLocalPort());
        }
        if (key.equals("SERVER_PROTOCOL")) {
            return this.request.getProtocol();
        }
        if (key.equals("SERVER_SOFTWARE")) {
            return "tomcat";
        }
        if (key.equals("THE_REQUEST")) {
            return this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        }
        if (key.equals("REQUEST_URI")) {
            return this.request.getRequestURI();
        }
        if (key.equals("REQUEST_FILENAME")) {
            return this.request.getPathTranslated();
        }
        if (key.equals("HTTPS")) {
            return this.request.isSecure() ? "on" : "off";
        }
        if (key.equals("TIME_YEAR")) {
            return String.valueOf(Calendar.getInstance().get(1));
        }
        if (key.equals("TIME_MON")) {
            return String.valueOf(Calendar.getInstance().get(2));
        }
        if (key.equals("TIME_DAY")) {
            return String.valueOf(Calendar.getInstance().get(5));
        }
        if (key.equals("TIME_HOUR")) {
            return String.valueOf(Calendar.getInstance().get(11));
        }
        if (key.equals("TIME_MIN")) {
            return String.valueOf(Calendar.getInstance().get(12));
        }
        if (key.equals("TIME_SEC")) {
            return String.valueOf(Calendar.getInstance().get(13));
        }
        if (key.equals("TIME_WDAY")) {
            return String.valueOf(Calendar.getInstance().get(7));
        }
        if (key.equals("TIME")) {
            return DateUtils.getCurrentDateTime(this.servletRequestContext.getExchange());
        }
        return null;
    }

    @Override
    public String resolveEnv(String key) {
        Object result = this.request.getAttribute(key);
        return result != null ? result.toString() : System.getProperty(key);
    }

    @Override
    public String resolveSsl(String key) {
        return null;
    }

    @Override
    public String resolveHttp(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public boolean resolveResource(int type, String name) {
        Resource resource;
        try {
            resource = this.servletRequestContext.getDeployment().getDeploymentInfo().getResourceManager().getResource(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        switch (type) {
            case 0: {
                return resource == null;
            }
            case 1: {
                return resource != null;
            }
            case 2: {
                return resource != null && resource.getContentLength() > 0L;
            }
        }
        return false;
    }

    private static String emptyStringIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

